﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;
using System.Linq;
using System.Reflection;
using System.Text;
using CoverageFramework.AstGenerator;
using CoverageFramework.Operator.Generator;
using CoverageFramework.Operator.Selector;

namespace CoverageFramework.Utility
{
	public class InstanceFactory
	{
		private static InstanceFactory _instance;

		private static InstanceFactory Instance
		{
			get { return _instance ?? (_instance = new InstanceFactory()); }
		}

		[ImportMany]
		private IEnumerable<IAstGenerator> _astGenerators = null;

		[ImportMany]
		private IEnumerable<IXElementSelector> _xElementSelectors = null;

		[ImportMany]
		private IEnumerable<IXElementGenerator> _xElementGenerators = null;

		public static IEnumerable<IAstGenerator> AstGenerators
		{
			get { return Instance._astGenerators; }
		}

		public static IEnumerable<IXElementSelector> XElementSelectors
		{
			get { return Instance._xElementSelectors; }
		}

		public static IEnumerable<IXElementGenerator> XElementGenerators
		{
			get { return Instance._xElementGenerators; }
		}

		private InstanceFactory()
		{
			var catalog = new AggregateCatalog();
			catalog.Catalogs.Add(new AssemblyCatalog(Assembly.GetExecutingAssembly()));
			catalog.Catalogs.Add(new DirectoryCatalog("Extensions"));
			var container = new CompositionContainer(catalog);
			container.ComposeParts(this);
		}
	}
}