#ifndef COVERAGE_MANAGER_H_
#define COVERAGE_MANAGER_H_

#undef UNICODE
#include <stdio.h>
#include <windows.h>

class CoverageManager
{
private:
	static HANDLE _hMemory;
	static char *_memory;
	
	static bool initialize(int nameNumberHigh, int nameNumberLow, int size) {
		char name[256];
		sprintf(name, "%d-%d-%d", nameNumberHigh, nameNumberLow, size);

		_hMemory = CreateFileMapping(
			(HANDLE)-1,			// t@C̃nh(0xFFFFFFFFƃt@C𐶐Ȃ)
			NULL,				// ZLeB
			PAGE_READWRITE,		// ی
			0,					// TCY\ DWORD
			size,				// TCY\ DWORD
			name);				// IuWFNgiʎqj
		if (GetLastError() == ERROR_ALREADY_EXISTS) {
			_hMemory = OpenFileMapping(
				FILE_MAP_ALL_ACCESS,	// ANZX[h
				FALSE,					// ptOiqvZXɌp邩ۂj
				name);					// IuWFNgiʎqj
		}
		if (_hMemory == NULL)
			return false;

		_memory = (char*)MapViewOfFile(
			_hMemory,				// t@C}bsOIuWFNg̃nh
			FILE_MAP_ALL_ACCESS,	// ANZX[h
			0,						// ItZbg̏ DWORD
			0,						// ItZbg̉ DWORD
			0);						// }bvΏۂ̃oCg
		if (_memory == NULL)
			return false;
		return true;
	}

	static void write(int nameNumberHigh, int nameNumberLow, int size, int id, char value) {
		if (_memory == NULL && initialize(nameNumberHigh, nameNumberLow, size) == false) {
			return;
		}
		_memory[id] |= value;
	}

public:
	static int read(int nameNumberHigh, int nameNumberLow, int size, int id) {
		if (_memory == NULL && initialize(nameNumberHigh, nameNumberLow, size) == false) {
			return -1;
		}
		return _memory[id];
	}
	
	static bool branch(int nameNumberHigh, int nameNumberLow, int size, int id, bool value) {
		write(nameNumberHigh, nameNumberLow, size, id, value ? 1 : 2);
		return value;
	}
	
	static void statement(int nameNumberHigh, int nameNumberLow, int size, int id) {
		write(nameNumberHigh, nameNumberLow, size, id, 3);
	}
};

extern int read(int nameNumberHigh, int nameNumberLow, int size, int id);
extern bool branch(int nameNumberHigh, int nameNumberLow, int size, int id, bool value);
extern void statement(int nameNumberHigh, int nameNumberLow, int size, int id);

#endif //COVERAGE_MANAGER_H_
