/**
 *  nbV@
 *
 *  @version $Revision: 1.4 $, $Date: 2003/04/28 23:23:16 $
 */

import java.io.*;
import java.util.ArrayList;
import java.util.Random;

public class HashAndTree {
    static final int HASH_SIZE = 101;  // nbV\̑傫ifj
    static final int CHAR_BIT = 8;  // 256i@̐Ƃ݂

    class Node {           // 2؂̃m[h
        Node left, right;  // E̎q
        String key;        // L[ij
    }

    Node zero, hashTable[];

    public HashAndTree() {
        zero = new Node();  // Ԑl
        hashTable = new Node[HASH_SIZE];  // nbV\
        for (int i = 0; i < HASH_SIZE; i++) hashTable[i] = zero;
    }

    private int hash(String s) {  // ȒPȃnbV֐
        int v = 0;
        for (int i = 0; i < s.length(); i++)
            v = ((v << CHAR_BIT) + s.charAt(i)) % HASH_SIZE;
        return v;
    }

    boolean insert(String word) {  // }io^j
        int cmp;  boolean isLeftChild = false;
        Node parent = null, child = hashTable[hash(word)];
        zero.key = word;  // Ԑl
        while ((cmp = child.key.compareTo(word)) != 0) {
            parent = child;
            if (cmp < 0) { child = child.left;  isLeftChild = true; }
            else         { child = child.right; isLeftChild = false; }
        }
        if (child != zero) return false;  // łɓo^Ă
        Node q = new Node();
        q.key = word;  q.left = zero;  q.right = child;
        if (parent == null) hashTable[hash(word)] = q;
        else if (isLeftChild) parent.left  = q;
        else                  parent.right = q;
        return true;  // o^
    }

    public static void main(String[] args) throws IOException {
		ArrayList<String> strs = new ArrayList<String>();
		final int N = 10000;

		Random rand = new Random();
		for (int i = 0; i < N; i++)
			strs.add("" + rand.nextDouble());

		HashAndTree hash = new HashAndTree();

		long time = System.currentTimeMillis();
		for (String s : strs)
			hash.insert(s);
		System.out.println(System.currentTimeMillis() - time);
    }
}
