#
# $Id: $
#
# LICENSE: GPL
#
module CodeDiff

  #----------------------------------------------------------------------------

  module HtmlConf
    def printCss(ostream)
      ostream << <<STYLE
a:link { color:#000; cursor:point; text-decoration:none }
a:hover { cursor:point; text-decoration:none }
a:visited { color:#000; cursor:point; text-decoration:none }
body { font-size:10pt; font-family:\"Verdana\",Serif; background-color:#fff }
h4.title { margin:20px 0px 10px 10px }
table { border-collapse:collapse; }
th.title { font-family:\"Verdana\"; font-size:18pt; text-align:left; padding:15px 10px 10px 20px; background-color:#fff }
th, td { font-family:\"Courier New\",Monospace; font-size:10pt; padding-left:20px }
td.del { background-color:#888 }
td.add { font-weight:bold; font-size:9pt; background-color:#ff0 }
td.blank { background-color:DarkGray }
td.same,td.omit { color:#444; background-color:#ccc }
td.omit { font-weight:bold; padding:20px }
span.c, span.g, span.m { color:#f00 }
span.a, span.u, span.p { color:#00f }
span.d { color:#880 }
p.timestamp { text-align:right; font-size:9pt; margin-right:20px }
STYLE
    end
  end

  #----------------------------------------------------------------------------

  module RssConf
    def printChannelHeader(os)
      os << <<HEADER
<title>CodeDiff</title>
<description>Repository Diff RSS</description>
<language>en-us</language>
HEADER
    end
  end

  #----------------------------------------------------------------------------

  module RcsConf
    SvnCommand = "/opt/local/bin/svn"
    DiffCommand = "/usr/bin/diff"

    def revision
      ret = 0
      if `#{SvnCommand} info`.match(/Revision\:\s+(\d+)/) then
        ret = $1
      end
      ret
    end

    def titleString(prev, curr)
      "Revision #{prev} to Revision #{curr}"
    end

    def cmdUpdate
      "#{SvnCommand} update"
    end

    def cmdFullDiff(prev)
      "#{SvnCommand} diff --revision #{prev}:HEAD --diff-cmd #{DiffCommand} -x \"--unified=100 --ignore-all-space\""
    end
    def cmdDiff(prev)
      "#{SvnCommand} diff --revision #{prev}:HEAD --diff-cmd #{DiffCommand} -x \"--unified=10 --ignore-all-space\""
    end
  end

end
