#!/usr/local/bin/ruby
#
# $Id: $
#
# LICENSE: GPL
#
# Primitive implementation
# This code is obsolete. Use diff2html.rb
#

def printStyle
  print <<STYLE
<style>
a:link { color:#000; cursor:point; text-decoration:none }
a:hover { cursor:point; text-decoration:none }
a:visited { color:#000; cursor:point; text-decoration:none }
body { font-family:\"Sydnie\",\"Courier New\",Monospaced; background-color:#333 }
table { border-collapse:collapse; }
th.title { font-family:\"Trebuchet MS\"; font-size:18pt; text-align:left; padding:10px; background-color:#fff }
td { font-size:9pt; padding-left:20px }
td.del { background-color:#888 }
td.add { font-weight:bold; font-size:9pt; background-color:#ff0 }
td.blank { background-color:DarkGray }
td.same,td.omit { color:#444; background-color:#ccc }
td.omit { font-weight:bold; padding:20px }
</style>
STYLE
end

def fillWithBlank(o, m)
  d = o.size - m.size
  while d != 0 do
    if d < 0 then
      o.push "<td class=\"blank\">&nbsp;</td>"
    else
      m.push "<td class=\"blank\">&nbsp;</td>"
    end
      d = o.size - m.size
  end
end

def convertSpace(s)
  ret = s.gsub(' ', '&nbsp;')
  0 == ret.length ? '&nbsp;' : ret
end

def diff2html(istream)
  orgLines = Array.new
  modLines = Array.new
  sngLines = Array.new
  orgName = ""
  modName = ""
  diffCount = 0
  fileCount = 0
  nextBlock = false

  istream.each do |line|
    line.chomp!
    line.gsub!( '&', '&amp;' )
    line.gsub!('\'', '&apos;')
    line.gsub!('"', '&quot;')
    line.gsub!( '<', '&lt;'  )
    line.gsub!( '>', '&gt;'  )
    line.gsub!("\t", '&nbsp;&nbsp;&nbsp;&nbsp;')

    if /^\-\-\-[\t\s]*([\w+\.\/\\\:]+)/.match(line) then
      orgName = $1
    elsif /^\+\+\+[\t\s]*([\w+\.\/\\\:]+)/.match(line) then
      modName = $1
      fillWithBlank(orgLines, modLines)
      orgLines.push "<th class=\"title\"><a name=\"file_#{fileCount}\"/><a name=\"#{orgName}\"/><a href=\"#file_#{fileCount+1}\">#{orgName} vs #{modName}</a></th>"
      modLines.push "<th class=\"title\">&nbsp;</th>"
      sngLines.push "<th class=\"title\"><a name=\"file_#{fileCount}\"/><a name=\"#{orgName}\"/><a href=\"#file_#{fileCount+1}\">#{orgName} vs #{modName}</a></th>"
      fileCount = fileCount + 1
      nextBlock = true
    elsif /^\-(.*)/.match(line) then
      l = convertSpace($1)
      if nextBlock then
        diffCount = diffCount + 1
        nextBlock = false
        orgLines.push "<td class=\"del\"><a name=\"diff_#{diffCount}\"/><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
        sngLines.push "<td class=\"del\"><a name=\"diff_#{diffCount}\"/><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
      else
        orgLines.push "<td class=\"del\"><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
        sngLines.push "<td class=\"del\"><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
      end
    elsif /^\+(.*)/.match(line) then
      l = convertSpace($1)
      if nextBlock then
        diffCount = diffCount + 1
        nextBlock = false
        modLines.push "<td class=\"add\"><a name=\"diff_#{diffCount}\"/><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
        sngLines.push "<td class=\"add\"><a name=\"diff_#{diffCount}\"/><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
      else
        modLines.push "<td class=\"add\"><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
        sngLines.push "<td class=\"add\"><a href=\"#diff_#{diffCount+1}\">#{l}</a></td>"
      end
    elsif /^\s(.*)/.match(line) then
      fillWithBlank(orgLines, modLines)
      l = convertSpace($1)
      orgLines.push "<td class=\"same\">#{l}</td>"
      modLines.push "<td class=\"same\">#{l}</td>"
      sngLines.push "<td class=\"same\">#{l}</td>"
      nextBlock = true
    elsif /^@@\s\-(\d+),(\d+)\s\+(\d+),(\d+)\s@@/.match(line) then
      orgLines.push "<td class=\"omit\">(From line #{$1} to #{$1.to_i+$2.to_i})</td>"
      modLines.push "<td class=\"omit\">(From line #{$1} to #{$1.to_i+$2.to_i})</td>"
      sngLines.push "<td class=\"omit\">(From line #{$1} to #{$1.to_i+$2.to_i})</td>"
      nextBlock = true
    end
  end
  fillWithBlank(orgLines, modLines)

  puts "<html>\n<head><title>#{orgName} vs #{modName}</title>"
  printStyle
  puts "</head>\n<body>\n<table cellspacing=\"0\" cellpadding=\"0\">"
  orgLines.size.times do |i|
    #puts "<tr>#{orgLines[i]}#{modLines[i]}</tr>"
    puts "<tr>#{sngLines[i]}</tr>"
  end
  puts "</table>\n</body>\n</html>"
end

if $0 == __FILE__ then
  diff2html(STDIN)
end
