/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.web.tomcat.tc5.session.SnapshotManager;

public class ClusteredSessionValve
extends ValveBase
implements Lifecycle {
    private static final String info = "ClusteredSessionValve/1.0";
    protected SnapshotManager snapshot;
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected static ThreadLocal requestThreadLocal = new ThreadLocal();
    protected static ThreadLocal responseThreadLocal = new ThreadLocal();

    public ClusteredSessionValve(SnapshotManager snapshot) {
        this.snapshot = snapshot;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        requestThreadLocal.set(request);
        responseThreadLocal.set(response);
        this.getNext().invoke(request, response);
        HttpSession session = request.getSession(false);
        if (session != null && session.getId() != null) {
            this.snapshot.snapshot(session.getId());
        }
        requestThreadLocal.set(null);
        responseThreadLocal.set(null);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.snapshot.start();
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
        this.snapshot.stop();
    }
}

