/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.SecurityDomain;
import org.jboss.security.Util;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.plugins.JaasSecurityDomainMBean;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.security.plugins.SubjectActions;

public class JaasSecurityDomain
extends JaasSecurityManager
implements SecurityDomain,
JaasSecurityDomainMBean {
    private static final RuntimePermission encodePermission = new RuntimePermission("org.jboss.security.plugins.JaasSecurityDomain.encode");
    private static final RuntimePermission decodePermission = new RuntimePermission("org.jboss.security.plugins.JaasSecurityDomain.decode");
    private KeyStore keyStore;
    private KeyManagerFactory keyMgr;
    private String keyStoreType = "JKS";
    private URL keyStoreURL;
    private char[] keyStorePassword;
    private String keyStorePasswordCmd;
    private String keyStorePasswordCmdType;
    private SecretKey cipherKey;
    private String cipherAlgorithm = "PBEwithMD5andDES";
    private byte[] salt = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    private int iterationCount = 103;
    private PBEParameterSpec cipherSpec;
    private ObjectName managerServiceName = JaasSecurityManagerServiceMBean.OBJECT_NAME;
    private KeyStore trustStore;
    private String trustStoreType = "JKS";
    private char[] trustStorePassword;
    private URL trustStoreURL;
    private TrustManagerFactory trustMgr;

    public JaasSecurityDomain() {
    }

    public JaasSecurityDomain(String securityDomain) {
        this(securityDomain, new SecurityAssociationHandler());
    }

    public JaasSecurityDomain(String securityDomain, CallbackHandler handler) {
        super(securityDomain, handler);
    }

    public KeyStore getKeyStore() throws SecurityException {
        return this.keyStore;
    }

    public KeyManagerFactory getKeyManagerFactory() throws SecurityException {
        return this.keyMgr;
    }

    public KeyStore getTrustStore() throws SecurityException {
        return this.trustStore;
    }

    public TrustManagerFactory getTrustManagerFactory() throws SecurityException {
        return this.trustMgr;
    }

    public ObjectName getManagerServiceName() {
        return this.managerServiceName;
    }

    public void setManagerServiceName(ObjectName managerServiceName) {
        this.managerServiceName = managerServiceName;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStoreURL() {
        String url = null;
        if (this.keyStoreURL != null) {
            url = this.keyStoreURL.toExternalForm();
        }
        return url;
    }

    public void setKeyStoreURL(String storeURL) throws IOException {
        this.keyStoreURL = this.validateStoreURL(storeURL);
        this.log.debug((Object)("Using KeyStore=" + this.keyStoreURL.toExternalForm()));
    }

    public void setKeyStorePass(String password) {
        this.keyStorePassword = null;
        if (password.charAt(0) == '{') {
            StringTokenizer tokenizer = new StringTokenizer(password, "{}");
            this.keyStorePasswordCmdType = tokenizer.nextToken();
            this.keyStorePasswordCmd = tokenizer.nextToken();
        } else {
            this.keyStorePassword = password.toCharArray();
        }
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String type) {
        this.trustStoreType = type;
    }

    public void setTrustStorePass(String password) {
        this.trustStorePassword = password.toCharArray();
    }

    public String getTrustStoreURL() {
        String url = null;
        if (this.trustStoreURL != null) {
            url = this.trustStoreURL.toExternalForm();
        }
        return url;
    }

    public void setTrustStoreURL(String storeURL) throws IOException {
        this.trustStoreURL = this.validateStoreURL(storeURL);
    }

    public void setSalt(String salt) {
        this.salt = salt.getBytes();
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public String getName() {
        return "JaasSecurityDomain(" + this.getSecurityDomain() + ")";
    }

    public byte[] encode(byte[] secret) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            System.out.println("Checking: " + encodePermission);
            sm.checkPermission(encodePermission);
        }
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(1, (Key)this.cipherKey, this.cipherSpec);
        byte[] encoding = cipher.doFinal(secret);
        return encoding;
    }

    public byte[] decode(byte[] secret) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(decodePermission);
        }
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        cipher.init(2, (Key)this.cipherKey, this.cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return decode;
    }

    public String encode64(byte[] secret) throws Exception {
        byte[] encoding = this.encode(secret);
        String b64 = Util.tob64(encoding);
        return b64;
    }

    public byte[] decode64(String secret) throws Exception {
        byte[] encoding = Util.fromb64(secret);
        byte[] decode = this.decode(encoding);
        return decode;
    }

    public void reloadKeyAndTrustStore() throws Exception {
        this.loadKeyAndTrustStore();
    }

    protected void startService() throws Exception {
        this.loadKeystorePassword();
        this.loadKeyAndTrustStore();
        MBeanServer server = MBeanServerLocator.locateJBoss();
        Object[] params = new Object[]{this.getSecurityDomain(), this};
        String[] signature = new String[]{"java.lang.String", "org.jboss.security.SecurityDomain"};
        server.invoke(this.managerServiceName, "registerSecurityDomain", params, signature);
    }

    protected void stopService() {
        if (this.keyStorePassword != null) {
            Arrays.fill(this.keyStorePassword, '\u0000');
            this.keyStorePassword = null;
        }
        this.cipherKey = null;
    }

    private void loadKeystorePassword() throws Exception {
        if (this.keyStorePassword == null) {
            if (this.keyStorePasswordCmdType.equals("EXT")) {
                this.execPasswordCmd();
            } else if (this.keyStorePasswordCmdType.equals("CLASS")) {
                this.invokePasswordClass();
            } else {
                throw new IllegalArgumentException("Unknown keyStorePasswordCmdType: " + this.keyStorePasswordCmdType);
            }
        }
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.keyStorePassword);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        this.cipherKey = factory.generateSecret(keySpec);
    }

    private void loadKeyAndTrustStore() throws Exception {
        String algorithm;
        InputStream is;
        if (this.keyStoreURL != null) {
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            is = this.keyStoreURL.openStream();
            this.keyStore.load(is, this.keyStorePassword);
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
            this.keyMgr = KeyManagerFactory.getInstance(algorithm);
            this.keyMgr.init(this.keyStore, this.keyStorePassword);
        }
        if (this.trustStoreURL != null) {
            this.trustStore = KeyStore.getInstance(this.trustStoreType);
            is = this.trustStoreURL.openStream();
            this.trustStore.load(is, this.trustStorePassword);
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
            this.trustMgr = TrustManagerFactory.getInstance(algorithm);
            this.trustMgr.init(this.trustStore);
        } else if (this.keyStore != null) {
            this.trustStore = this.keyStore;
            String algorithm2 = TrustManagerFactory.getDefaultAlgorithm();
            this.trustMgr = TrustManagerFactory.getInstance(algorithm2);
            this.trustMgr.init(this.trustStore);
        }
    }

    private void execPasswordCmd() throws Exception {
        this.log.debug((Object)("Executing command: " + this.keyStorePasswordCmd));
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(this.keyStorePasswordCmd);
        InputStream stdin = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdin));
        String password = reader.readLine();
        stdin.close();
        int exitCode = p.waitFor();
        this.log.debug((Object)("Command exited with: " + exitCode));
        this.keyStorePassword = password.toCharArray();
    }

    private void invokePasswordClass() throws Exception {
        block5: {
            Object[] args;
            Class[] sig;
            this.keyStorePassword = null;
            String classname = this.keyStorePasswordCmd;
            String ctorArg = null;
            int colon = this.keyStorePasswordCmd.indexOf(58);
            if (colon > 0) {
                classname = this.keyStorePasswordCmd.substring(0, colon);
                ctorArg = this.keyStorePasswordCmd.substring(colon + 1);
            }
            this.log.debug((Object)("Loading class: " + classname + ", ctorArg=" + ctorArg));
            ClassLoader loader = SubjectActions.getContextClassLoader();
            Class<?> c = loader.loadClass(classname);
            Object instance = null;
            if (ctorArg != null) {
                sig = new Class[]{String.class};
                Constructor<?> ctor = c.getConstructor(sig);
                args = new Object[]{ctorArg};
                instance = ctor.newInstance(args);
            } else {
                instance = c.newInstance();
            }
            try {
                this.log.debug((Object)"Checking for toCharArray");
                sig = new Class[]{};
                Method toCharArray = c.getMethod("toCharArray", sig);
                args = new Object[]{};
                this.log.debug((Object)"Invoking toCharArray");
                this.keyStorePassword = (char[])toCharArray.invoke(instance, args);
            }
            catch (NoSuchMethodException e) {
                this.log.debug((Object)"No toCharArray found, invoking toString");
                String tmp = instance.toString();
                if (tmp == null) break block5;
                this.keyStorePassword = tmp.toCharArray();
            }
        }
    }

    private URL validateStoreURL(String storeURL) throws IOException {
        File tst;
        URL url = null;
        try {
            url = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (tst = new File(storeURL)).exists()) {
            url = tst.toURL();
        }
        if (url == null) {
            ClassLoader loader = SubjectActions.getContextClassLoader();
            url = loader.getResource(storeURL);
        }
        if (url == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }
}

