/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core.types;

import com.edb.core.types.PGBigDecimal;
import com.edb.core.types.PGDouble;
import com.edb.core.types.PGFloat;
import com.edb.core.types.PGInteger;
import com.edb.core.types.PGLong;
import com.edb.core.types.PGShort;
import com.edb.core.types.PGString;
import com.edb.core.types.PGType;
import com.edb.core.types.PGUnknown;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.math.BigDecimal;

public class PGBoolean
implements PGType {
    private Boolean val;

    public PGBoolean(Boolean x) {
        this.val = x;
    }

    public static PGType castToServerType(Boolean val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -5: {
                    return new PGLong(new Long(val == true ? 1L : 0L));
                }
                case 4: {
                    return new PGInteger(new Integer(val == true ? 1 : 0));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(val == true ? (short)1 : 0));
                }
                case -1: 
                case 12: {
                    return new PGString(val == true ? "true" : "false");
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(val == true ? 1.0 : 0.0));
                }
                case 7: {
                    return new PGFloat(new Float(val == true ? 1.0f : 0.0f));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val == true ? 1.0 : 0.0));
                }
                case -7: {
                    return new PGBoolean(val);
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    public String toString() {
        return this.val == true ? "true" : "false";
    }
}

