/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.console.twiddle.command.Command;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.NoSuchCommandException;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.Strings;

public class Twiddle {
    public static final String PROGRAM_NAME = System.getProperty("program.name", "twiddle");
    public static final String CMD_PROPERTIES = "/org/jboss/console/twiddle/commands.properties";
    public static final String DEFAULT_JNDI_NAME = "jmx/invoker/RMIAdaptor";
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$console$twiddle$Twiddle == null ? (class$org$jboss$console$twiddle$Twiddle = Twiddle.class$("org.jboss.console.twiddle.Twiddle")) : class$org$jboss$console$twiddle$Twiddle));
    private static Twiddle twiddle = new Twiddle(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    private static String commandName;
    private static String[] commandArgs;
    private static boolean commandHelp;
    private static URL cmdProps;
    private List commandProtoList = new ArrayList();
    private Map commandProtoMap = new HashMap();
    private PrintWriter out;
    private PrintWriter err;
    private String serverURL;
    private String adapterName;
    private boolean quiet;
    private MBeanServerConnection server;
    static /* synthetic */ Class class$org$jboss$console$twiddle$Twiddle;

    public Twiddle(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
    }

    public void setServerURL(String url) {
        this.serverURL = url;
    }

    public void setAdapterName(String name) {
        this.adapterName = name;
    }

    public void setQuiet(boolean flag) {
        this.quiet = flag;
    }

    public void addCommandPrototype(Command proto) {
        String name = proto.getName();
        log.debug((Object)("Adding command '" + name + "'; proto: " + proto));
        this.commandProtoList.add(proto);
        this.commandProtoMap.put(name, proto);
    }

    private CommandContext createCommandContext() {
        return new CommandContext(){

            public boolean isQuiet() {
                return Twiddle.this.quiet;
            }

            public PrintWriter getWriter() {
                return Twiddle.this.out;
            }

            public PrintWriter getErrorWriter() {
                return Twiddle.this.err;
            }

            public MBeanServerConnection getServer() {
                try {
                    Twiddle.this.connect();
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
                return Twiddle.this.server;
            }
        };
    }

    public Command createCommand(String name) throws NoSuchCommandException, Exception {
        Command proto = (Command)this.commandProtoMap.get(name);
        if (proto == null) {
            throw new NoSuchCommandException(name);
        }
        Command command = (Command)proto.clone();
        command.setCommandContext(this.createCommandContext());
        return command;
    }

    private int getMaxCommandNameLength() {
        int max = 0;
        Iterator iter = this.commandProtoList.iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            String name = command.getName();
            if (name.length() <= max) continue;
            max = name.length();
        }
        return max;
    }

    public void displayCommandList() {
        if (this.commandProtoList.size() == 0) {
            try {
                Twiddle.loadCommands();
            }
            catch (Exception e) {
                System.err.println("Failed to load commnads from: " + cmdProps);
                e.printStackTrace();
            }
        }
        Iterator iter = this.commandProtoList.iterator();
        this.out.println(PROGRAM_NAME + " commands: ");
        int maxNameLength = this.getMaxCommandNameLength();
        log.debug((Object)("max command name length: " + maxNameLength));
        while (iter.hasNext()) {
            Command proto = (Command)iter.next();
            String name = proto.getName();
            String desc = proto.getDescription();
            this.out.print("    ");
            this.out.print(name);
            this.out.print(Strings.pad((String)" ", (int)(maxNameLength - name.length())));
            this.out.print("    ");
            this.out.println(desc);
        }
        this.out.flush();
    }

    private MBeanServerConnection createMBeanServerConnection() throws NamingException {
        InitialContext ctx;
        if (this.serverURL == null) {
            ctx = new InitialContext();
        } else {
            Properties props = new Properties(System.getProperties());
            props.put("java.naming.provider.url", this.serverURL);
            ctx = new InitialContext(props);
        }
        if (this.adapterName == null) {
            this.adapterName = DEFAULT_JNDI_NAME;
        }
        Object obj = ctx.lookup(this.adapterName);
        ctx.close();
        if (!(obj instanceof RMIAdaptor)) {
            throw new ClassCastException("Object not of type: RMIAdaptorImpl, but: " + (obj == null ? "not found" : obj.getClass().getName()));
        }
        return (MBeanServerConnection)obj;
    }

    private void connect() throws NamingException {
        if (this.server == null) {
            this.server = this.createMBeanServerConnection();
        }
    }

    public static void main(String[] args) {
        Command command = null;
        try {
            Twiddle.processArguments(args);
            Twiddle.loadCommands();
            if (commandName == null) {
                Twiddle.displayHelp();
            } else {
                command = twiddle.createCommand(commandName);
                if (commandHelp) {
                    command.displayHelp();
                } else {
                    command.execute(commandArgs);
                }
            }
            System.exit(0);
        }
        catch (CommandException e) {
            log.error((Object)"Command failure", (Throwable)((Object)e));
            if (e instanceof NoSuchCommandException) {
                System.err.println();
                twiddle.displayCommandList();
            } else {
                System.err.println();
                if (command != null) {
                    command.displayHelp();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Exec failed", (Throwable)e);
        }
    }

    private static void loadCommands() throws Exception {
        if (cmdProps == null) {
            cmdProps = (class$org$jboss$console$twiddle$Twiddle == null ? (class$org$jboss$console$twiddle$Twiddle = Twiddle.class$("org.jboss.console.twiddle.Twiddle")) : class$org$jboss$console$twiddle$Twiddle).getResource(CMD_PROPERTIES);
        }
        if (cmdProps == null) {
            throw new IllegalStateException("Failed to find: /org/jboss/console/twiddle/commands.properties");
        }
        InputStream input = cmdProps.openStream();
        log.debug((Object)("command proto type properties: " + cmdProps));
        Properties props = new Properties();
        props.load(input);
        input.close();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String typeName = props.getProperty(name);
            Class<?> type = Class.forName(typeName);
            twiddle.addCommandPrototype((Command)type.newInstance());
        }
    }

    private static void displayHelp() {
        PrintStream out = System.out;
        out.println("A JMX client to 'twiddle' with a remote JBoss server.");
        out.println();
        out.println("usage: " + PROGRAM_NAME + " [options] <command> [command_arguments]");
        out.println();
        out.println("options:");
        out.println("    -h, --help                Show this help message");
        out.println("        --help-commands       Show a list of commands");
        out.println("    -H=<command>              Show command specific help");
        out.println("    -c=command.properties     Specify the command.properties file to use");
        out.println("    -D<name>[=<value>]        Set a system property");
        out.println("    --                        Stop processing options");
        out.println("    -s, --server=<url>        The JNDI URL of the remote server");
        out.println("    -a, --adapter=<name>      The JNDI name of the RMI adapter to use");
        out.println("    -u, --user=<name>         Specify the username for authentication");
        out.println("    -p, --password=<name>     Specify the password for authentication");
        out.println("    -q, --quiet               Be somewhat more quiet");
        out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processArguments(String[] args) throws Exception {
        int code;
        for (int a = 0; a < args.length; ++a) {
            log.debug((Object)("args[" + a + "]=" + args[a]));
        }
        String sopts = "-:hH:u:p:c:D:s:a:q";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("help-commands", 0, null, 4096), new LongOpt("server", 1, null, 115), new LongOpt("adapter", 1, null, 97), new LongOpt("quiet", 0, null, 113), new LongOpt("user", 1, null, 117), new LongOpt("password", 1, null, 112)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    break;
                }
                case 1: {
                    commandName = getopt.getOptarg();
                    log.debug((Object)("Command name: " + commandName));
                    int i = getopt.getOptind();
                    if (args.length > i) {
                        commandArgs = new String[args.length - i];
                        System.arraycopy(args, i, commandArgs, 0, args.length - i);
                    } else {
                        commandArgs = new String[0];
                    }
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)("Command arguments: " + Strings.join((Object[])commandArgs, (String)",")));
                    return;
                }
                case 104: {
                    Twiddle.displayHelp();
                    System.exit(0);
                    break;
                }
                case 72: {
                    commandName = getopt.getOptarg();
                    commandHelp = true;
                    return;
                }
                case 4096: {
                    twiddle.displayCommandList();
                    System.exit(0);
                    break;
                }
                case 99: {
                    String props = getopt.getOptarg();
                    try {
                        cmdProps = new URL(props);
                    }
                    catch (MalformedURLException e) {
                        log.debug((Object)"Failed to use cmd props as url", (Throwable)e);
                        File path = new File(props);
                        if (!path.exists()) {
                            String msg = "Failed to locate command props: " + props + " as URL or file";
                            throw new IllegalArgumentException(msg);
                        }
                        cmdProps = path.toURL();
                    }
                    break;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    break;
                }
                case 115: {
                    twiddle.setServerURL(getopt.getOptarg());
                    break;
                }
                case 97: {
                    twiddle.setAdapterName(getopt.getOptarg());
                    break;
                }
                case 117: {
                    String username = getopt.getOptarg();
                    SecurityAssociation.setPrincipal((Principal)new SimplePrincipal(username));
                    break;
                }
                case 112: {
                    String password = getopt.getOptarg();
                    SecurityAssociation.setCredential((Object)password);
                    break;
                }
                case 113: {
                    twiddle.setQuiet(true);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

