/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.InterpreterError;
import bsh.ParserConstants;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.io.Serializable;

public class Primitive
implements ParserConstants,
Serializable {
    private Object value;
    public static final Primitive NULL = new Primitive(Special.NULL_VALUE);
    public static final Primitive VOID = new Primitive(Special.VOID_TYPE);
    static /* synthetic */ Class class$bsh$Primitive;

    private Primitive(Object object2) {
        if (object2 == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        this.value = object2;
    }

    public Primitive(Number number) {
        this((Object)number);
    }

    public Primitive(Boolean bl) {
        this((Object)bl);
    }

    public Primitive(Byte by) {
        this((Object)by);
    }

    public Primitive(Short s2) {
        this((Object)s2);
    }

    public Primitive(Character c2) {
        this((Object)c2);
    }

    public Primitive(Integer n) {
        this((Object)n);
    }

    public Primitive(Long l) {
        this((Object)l);
    }

    public Primitive(Float f2) {
        this((Object)f2);
    }

    public Primitive(Double d2) {
        this((Object)d2);
    }

    public Primitive(boolean bl) {
        this(new Boolean(bl));
    }

    public Primitive(byte by) {
        this(new Byte(by));
    }

    public Primitive(short s2) {
        this(new Short(s2));
    }

    public Primitive(char c2) {
        this(new Character(c2));
    }

    public Primitive(int n) {
        this(new Integer(n));
    }

    public Primitive(long l) {
        this(new Long(l));
    }

    public Primitive(float f2) {
        this(new Float(f2));
    }

    public Primitive(double d2) {
        this(new Double(d2));
    }

    public Object getValue() {
        if (this.value == Special.NULL_VALUE) {
            return null;
        }
        if (this.value == Special.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    public String toString() {
        if (this.value == Special.NULL_VALUE) {
            return "null";
        }
        if (this.value == Special.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public Class getType() {
        if (this == VOID) {
            return Void.TYPE;
        }
        if (this == NULL) {
            return null;
        }
        if (this.value instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (this.value instanceof Byte) {
            return Byte.TYPE;
        }
        if (this.value instanceof Short) {
            return Short.TYPE;
        }
        if (this.value instanceof Character) {
            return Character.TYPE;
        }
        if (this.value instanceof Integer) {
            return Integer.TYPE;
        }
        if (this.value instanceof Long) {
            return Long.TYPE;
        }
        if (this.value instanceof Float) {
            return Float.TYPE;
        }
        if (this.value instanceof Double) {
            return Double.TYPE;
        }
        throw new InterpreterError("uknown prim: " + this);
    }

    public static Object binaryOperation(Object object2, Object object3, int n) throws UtilEvalError {
        Object object4;
        if (object2 == NULL || object3 == NULL) {
            throw new UtilEvalError("Null value or 'null' literal in binary operation");
        }
        if (object2 == VOID || object3 == VOID) {
            throw new UtilEvalError("Undefined variable, class, or 'void' literal in binary operation");
        }
        Class<?> clazz = object2.getClass();
        Class<?> clazz2 = object3.getClass();
        if (object2 instanceof Primitive) {
            object2 = ((Primitive)object2).getValue();
        }
        if (object3 instanceof Primitive) {
            object3 = ((Primitive)object3).getValue();
        }
        Object[] objectArray = Primitive.promotePrimitives(object2, object3);
        Object object5 = objectArray[0];
        Object object6 = objectArray[1];
        if (object5.getClass() != object6.getClass()) {
            throw new UtilEvalError("Type mismatch in operator.  " + object5.getClass() + " cannot be used with " + object6.getClass());
        }
        try {
            object4 = Primitive.binaryOperationImpl(object5, object6, n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new UtilTargetError("Arithemetic Exception in binary op", arithmeticException);
        }
        if (clazz == (class$bsh$Primitive == null ? (class$bsh$Primitive = Primitive.class$("bsh.Primitive")) : class$bsh$Primitive) && clazz2 == (class$bsh$Primitive == null ? (class$bsh$Primitive = Primitive.class$("bsh.Primitive")) : class$bsh$Primitive) || object4 instanceof Boolean) {
            return new Primitive(object4);
        }
        return object4;
    }

    static Object binaryOperationImpl(Object object2, Object object3, int n) throws UtilEvalError {
        if (object2 instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)object2, (Boolean)object3, n);
        }
        if (object2 instanceof Integer) {
            return Primitive.intBinaryOperation((Integer)object2, (Integer)object3, n);
        }
        if (object2 instanceof Long) {
            return Primitive.longBinaryOperation((Long)object2, (Long)object3, n);
        }
        if (object2 instanceof Float) {
            return Primitive.floatBinaryOperation((Float)object2, (Float)object3, n);
        }
        if (object2 instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)object2, (Double)object3, n);
        }
        throw new UtilEvalError("Invalid types in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean bl, Boolean bl2, int n) throws UtilEvalError {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        switch (n) {
            case 90: {
                return new Boolean(bl3 == bl4);
            }
            case 95: {
                return new Boolean(bl3 != bl4);
            }
            case 96: 
            case 97: {
                return new Boolean(bl3 || bl4);
            }
            case 98: 
            case 99: {
                return new Boolean(bl3 && bl4);
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static Object longBinaryOperation(Long l, Long l2, int n) {
        long l3 = l;
        long l4 = l2;
        switch (n) {
            case 84: 
            case 85: {
                return new Boolean(l3 < l4);
            }
            case 82: 
            case 83: {
                return new Boolean(l3 > l4);
            }
            case 90: {
                return new Boolean(l3 == l4);
            }
            case 91: 
            case 92: {
                return new Boolean(l3 <= l4);
            }
            case 93: 
            case 94: {
                return new Boolean(l3 >= l4);
            }
            case 95: {
                return new Boolean(l3 != l4);
            }
            case 102: {
                return new Long(l3 + l4);
            }
            case 103: {
                return new Long(l3 - l4);
            }
            case 104: {
                return new Long(l3 * l4);
            }
            case 105: {
                return new Long(l3 / l4);
            }
            case 111: {
                return new Long(l3 % l4);
            }
            case 112: 
            case 113: {
                return new Long(l3 << (int)l4);
            }
            case 114: 
            case 115: {
                return new Long(l3 >> (int)l4);
            }
            case 116: 
            case 117: {
                return new Long(l3 >>> (int)l4);
            }
            case 106: 
            case 107: {
                return new Long(l3 & l4);
            }
            case 108: 
            case 109: {
                return new Long(l3 | l4);
            }
            case 110: {
                return new Long(l3 ^ l4);
            }
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static Object intBinaryOperation(Integer n, Integer n2, int n3) {
        int n4 = n;
        int n5 = n2;
        switch (n3) {
            case 84: 
            case 85: {
                return new Boolean(n4 < n5);
            }
            case 82: 
            case 83: {
                return new Boolean(n4 > n5);
            }
            case 90: {
                return new Boolean(n4 == n5);
            }
            case 91: 
            case 92: {
                return new Boolean(n4 <= n5);
            }
            case 93: 
            case 94: {
                return new Boolean(n4 >= n5);
            }
            case 95: {
                return new Boolean(n4 != n5);
            }
            case 102: {
                return new Integer(n4 + n5);
            }
            case 103: {
                return new Integer(n4 - n5);
            }
            case 104: {
                return new Integer(n4 * n5);
            }
            case 105: {
                return new Integer(n4 / n5);
            }
            case 111: {
                return new Integer(n4 % n5);
            }
            case 112: 
            case 113: {
                return new Integer(n4 << n5);
            }
            case 114: 
            case 115: {
                return new Integer(n4 >> n5);
            }
            case 116: 
            case 117: {
                return new Integer(n4 >>> n5);
            }
            case 106: 
            case 107: {
                return new Integer(n4 & n5);
            }
            case 108: 
            case 109: {
                return new Integer(n4 | n5);
            }
            case 110: {
                return new Integer(n4 ^ n5);
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static Object doubleBinaryOperation(Double d2, Double d3, int n) throws UtilEvalError {
        double d4 = d2;
        double d5 = d3;
        switch (n) {
            case 84: 
            case 85: {
                return new Boolean(d4 < d5);
            }
            case 82: 
            case 83: {
                return new Boolean(d4 > d5);
            }
            case 90: {
                return new Boolean(d4 == d5);
            }
            case 91: 
            case 92: {
                return new Boolean(d4 <= d5);
            }
            case 93: 
            case 94: {
                return new Boolean(d4 >= d5);
            }
            case 95: {
                return new Boolean(d4 != d5);
            }
            case 102: {
                return new Double(d4 + d5);
            }
            case 103: {
                return new Double(d4 - d5);
            }
            case 104: {
                return new Double(d4 * d5);
            }
            case 105: {
                return new Double(d4 / d5);
            }
            case 111: {
                return new Double(d4 % d5);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                throw new UtilEvalError("Can't shift doubles");
            }
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static Object floatBinaryOperation(Float f2, Float f3, int n) throws UtilEvalError {
        float f4 = f2.floatValue();
        float f5 = f3.floatValue();
        switch (n) {
            case 84: 
            case 85: {
                return new Boolean(f4 < f5);
            }
            case 82: 
            case 83: {
                return new Boolean(f4 > f5);
            }
            case 90: {
                return new Boolean(f4 == f5);
            }
            case 91: 
            case 92: {
                return new Boolean(f4 <= f5);
            }
            case 93: 
            case 94: {
                return new Boolean(f4 >= f5);
            }
            case 95: {
                return new Boolean(f4 != f5);
            }
            case 102: {
                return new Float(f4 + f5);
            }
            case 103: {
                return new Float(f4 - f5);
            }
            case 104: {
                return new Float(f4 * f5);
            }
            case 105: {
                return new Float(f4 / f5);
            }
            case 111: {
                return new Float(f4 % f5);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                throw new UtilEvalError("Can't shift floats ");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static Object promoteToInteger(Object object2) {
        if (object2 instanceof Character) {
            return new Integer(((Character)object2).charValue());
        }
        if (object2 instanceof Byte || object2 instanceof Short) {
            return new Integer(((Number)object2).intValue());
        }
        return object2;
    }

    static Object[] promotePrimitives(Object object2, Object object3) {
        object2 = Primitive.promoteToInteger(object2);
        object3 = Primitive.promoteToInteger(object3);
        if (object2 instanceof Number && object3 instanceof Number) {
            Number number = (Number)object2;
            Number number2 = (Number)object3;
            boolean bl = number instanceof Double;
            if (bl || number2 instanceof Double) {
                if (bl) {
                    object3 = new Double(number2.doubleValue());
                } else {
                    object2 = new Double(number.doubleValue());
                }
            } else {
                bl = number instanceof Float;
                if (bl || number2 instanceof Float) {
                    if (bl) {
                        object3 = new Float(number2.floatValue());
                    } else {
                        object2 = new Float(number.floatValue());
                    }
                } else {
                    bl = number instanceof Long;
                    if (bl || number2 instanceof Long) {
                        if (bl) {
                            object3 = new Long(number2.longValue());
                        } else {
                            object2 = new Long(number.longValue());
                        }
                    }
                }
            }
        }
        return new Object[]{object2, object3};
    }

    public static Primitive unaryOperation(Primitive primitive, int n) throws UtilEvalError {
        if (primitive == NULL) {
            throw new UtilEvalError("illegal use of null object or 'null' literal");
        }
        if (primitive == VOID) {
            throw new UtilEvalError("illegal use of undefined object or 'void' literal");
        }
        Class clazz = primitive.getType();
        Object object2 = Primitive.promoteToInteger(primitive.getValue());
        if (object2 instanceof Boolean) {
            return new Primitive(Primitive.booleanUnaryOperation((Boolean)object2, n));
        }
        if (object2 instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object2, n);
            if (n == 100 || n == 101) {
                if (clazz == Byte.TYPE) {
                    return new Primitive((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Primitive((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Primitive((char)n2);
                }
            }
            return new Primitive(n2);
        }
        if (object2 instanceof Long) {
            return new Primitive(Primitive.longUnaryOperation((Long)object2, n));
        }
        if (object2 instanceof Float) {
            return new Primitive(Primitive.floatUnaryOperation((Float)object2, n));
        }
        if (object2 instanceof Double) {
            return new Primitive(Primitive.doubleUnaryOperation((Double)object2, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    static boolean booleanUnaryOperation(Boolean bl, int n) throws UtilEvalError {
        boolean bl2 = bl;
        switch (n) {
            case 86: {
                return !bl2;
            }
        }
        throw new UtilEvalError("Operator inappropriate for boolean");
    }

    static int intUnaryOperation(Integer n, int n2) {
        int n3 = n;
        switch (n2) {
            case 102: {
                return n3;
            }
            case 103: {
                return -n3;
            }
            case 87: {
                return ~n3;
            }
            case 100: {
                return n3 + 1;
            }
            case 101: {
                return n3 - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    static long longUnaryOperation(Long l, int n) {
        long l2 = l;
        switch (n) {
            case 102: {
                return l2;
            }
            case 103: {
                return -l2;
            }
            case 87: {
                return l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 100: {
                return l2 + 1L;
            }
            case 101: {
                return l2 - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    static float floatUnaryOperation(Float f2, int n) {
        float f3 = f2.floatValue();
        switch (n) {
            case 102: {
                return f3;
            }
            case 103: {
                return -f3;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    static double doubleUnaryOperation(Double d2, int n) {
        double d3 = d2;
        switch (n) {
            case 102: {
                return d3;
            }
            case 103: {
                return -d3;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }

    public int intValue() throws UtilEvalError {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw new UtilEvalError("Primitive not a number");
    }

    public boolean booleanValue() throws UtilEvalError {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new UtilEvalError("Primitive not a boolean");
    }

    public boolean isNumber() {
        return !(this.value instanceof Boolean) && this != NULL && this != VOID;
    }

    public Number numberValue() throws UtilEvalError {
        Object object2 = this.value;
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (object2 instanceof Number) {
            return (Number)object2;
        }
        throw new UtilEvalError("Primitive not a number");
    }

    public boolean equals(Object object2) {
        if (object2 instanceof Primitive) {
            return ((Primitive)object2).value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode() * 21;
    }

    public static Object unwrap(Object object2) {
        if (object2 == VOID) {
            return null;
        }
        if (object2 instanceof Primitive) {
            return ((Primitive)object2).getValue();
        }
        return object2;
    }

    public static Primitive getDefaultValue(Class clazz) {
        if (clazz != null && clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return new Primitive(Boolean.FALSE);
            }
            if (clazz == Byte.TYPE) {
                return new Primitive(0);
            }
            if (clazz == Short.TYPE) {
                return new Primitive(0);
            }
            if (clazz == Character.TYPE) {
                return new Primitive('\u0000');
            }
            if (clazz == Integer.TYPE) {
                return new Primitive(0);
            }
            if (clazz == Long.TYPE) {
                return new Primitive(0L);
            }
            if (clazz == Float.TYPE) {
                return new Primitive(0.0f);
            }
            if (clazz == Double.TYPE) {
                return new Primitive(0.0);
            }
            throw new InterpreterError("unknown prim");
        }
        return NULL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Special
    implements Serializable {
        public static final Special NULL_VALUE = new Special();
        public static final Special VOID_TYPE = new Special();

        private Special() {
        }
    }
}

