/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.search.AddressTerm;

public final class RecipientTerm
extends AddressTerm {
    protected Message.RecipientType type;

    public RecipientTerm(Message.RecipientType recipientType, Address address2) {
        super(address2);
        this.type = recipientType;
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    public boolean match(Message message) {
        Address[] addressArray;
        try {
            addressArray = message.getRecipients(this.type);
        }
        catch (Exception exception) {
            return false;
        }
        if (addressArray == null) {
            return false;
        }
        int n = 0;
        while (n < addressArray.length) {
            if (super.match(addressArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof RecipientTerm)) {
            return false;
        }
        RecipientTerm recipientTerm = (RecipientTerm)object2;
        return recipientTerm.type.equals(this.type) && super.equals(object2);
    }

    public int hashCode() {
        return this.type.hashCode() + super.hashCode();
    }
}

