/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.util.HexDump;

public abstract class Ptg {
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    protected byte ptgClass = 0;

    public static Ptg createPtg(byte[] data, int offset) {
        byte id = data[offset + 0];
        Ptg retval = null;
        int valueRef = 68;
        int arrayRef = 100;
        int valueFunc = 65;
        int arrayFunc = 97;
        int valueFuncVar = 66;
        int arrayFuncVar = 98;
        int valueArea = 69;
        int arrayArea = 101;
        switch (id) {
            case 3: {
                retval = new AddPtg(data, offset);
                break;
            }
            case 4: {
                retval = new SubtractPtg(data, offset);
                break;
            }
            case 29: {
                retval = new BoolPtg(data, offset);
                break;
            }
            case 30: {
                retval = new IntPtg(data, offset);
                break;
            }
            case 6: {
                retval = new DividePtg(data, offset);
                break;
            }
            case 5: {
                retval = new MultiplyPtg(data, offset);
                break;
            }
            case 7: {
                retval = new PowerPtg(data, offset);
                break;
            }
            case 11: {
                retval = new EqualPtg(data, offset);
                break;
            }
            case 13: {
                retval = new GreaterThanPtg(data, offset);
                break;
            }
            case 9: {
                retval = new LessThanPtg(data, offset);
                break;
            }
            case 10: {
                retval = new LessEqualPtg(data, offset);
                break;
            }
            case 12: {
                retval = new GreaterEqualPtg(data, offset);
                break;
            }
            case 14: {
                retval = new NotEqualPtg(data, offset);
                break;
            }
            case 8: {
                retval = new ConcatPtg(data, offset);
                break;
            }
            case 37: {
                retval = new AreaPtg(data, offset);
                break;
            }
            case 69: {
                retval = new AreaPtg(data, offset);
                break;
            }
            case 101: {
                retval = new AreaPtg(data, offset);
                break;
            }
            case 39: 
            case 71: 
            case 103: {
                retval = new MemErrPtg(data, offset);
                break;
            }
            case 25: {
                retval = new AttrPtg(data, offset);
                break;
            }
            case 36: {
                retval = new ReferencePtg(data, offset);
                break;
            }
            case 68: {
                retval = new ReferencePtg(data, offset);
                break;
            }
            case 100: {
                retval = new ReferencePtg(data, offset);
                break;
            }
            case 21: {
                retval = new ParenthesisPtg(data, offset);
                break;
            }
            case 41: {
                retval = new MemFuncPtg(data, offset);
                break;
            }
            case 16: {
                retval = new UnionPtg(data, offset);
                break;
            }
            case 33: {
                retval = new FuncPtg(data, offset);
                break;
            }
            case 65: {
                retval = new FuncPtg(data, offset);
                break;
            }
            case 97: {
                retval = new FuncPtg(data, offset);
                break;
            }
            case 34: {
                retval = new FuncVarPtg(data, offset);
                break;
            }
            case 66: {
                retval = new FuncVarPtg(data, offset);
                break;
            }
            case 98: {
                retval = new FuncVarPtg(data, offset);
                break;
            }
            case 31: {
                retval = new NumberPtg(data, offset);
                break;
            }
            case 23: {
                retval = new StringPtg(data, offset);
                break;
            }
            case 35: 
            case 67: 
            case 99: {
                retval = new NamePtg(data, offset);
                break;
            }
            case 57: 
            case 89: 
            case 121: {
                retval = new NameXPtg(data, offset);
                break;
            }
            case 1: {
                retval = new ExpPtg(data, offset);
                break;
            }
            case 59: 
            case 91: 
            case 123: {
                retval = new Area3DPtg(data, offset);
                break;
            }
            case 58: 
            case 90: 
            case 122: {
                retval = new Ref3DPtg(data, offset);
                break;
            }
            case 22: {
                retval = new MissingArgPtg(data, offset);
                break;
            }
            case 18: {
                retval = new UnaryPlusPtg(data, offset);
                break;
            }
            case 19: {
                retval = new UnaryMinusPtg(data, offset);
                break;
            }
            default: {
                throw new UnsupportedOperationException(Integer.toHexString(id) + " (" + id + ")");
            }
        }
        if (id > 96) {
            retval.setClass((byte)64);
        } else if (id > 64) {
            retval.setClass((byte)32);
        } else {
            retval.setClass((byte)0);
        }
        return retval;
    }

    public abstract int getSize();

    public final byte[] getBytes() {
        int size = this.getSize();
        byte[] bytes = new byte[size];
        this.writeBytes(bytes, 0);
        return bytes;
    }

    public abstract void writeBytes(byte[] var1, int var2);

    public abstract String toFormulaString(Workbook var1);

    public String toDebugString() {
        byte[] ba = new byte[this.getSize()];
        String retval = null;
        this.writeBytes(ba, 0);
        try {
            retval = HexDump.dump(ba, 0L, 0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return retval;
    }

    public String toString() {
        return this.getClass().toString();
    }

    public void setClass(byte thePtgClass) {
        this.ptgClass = thePtgClass;
    }

    public byte getPtgClass() {
        return this.ptgClass;
    }

    public abstract byte getDefaultOperandClass();

    public abstract Object clone();
}

