/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.HeaderRecord;

public class HSSFHeader {
    HeaderRecord headerRecord;
    String left;
    String center;
    String right;

    protected HSSFHeader(HeaderRecord headerRecord) {
        this.headerRecord = headerRecord;
        String head2 = headerRecord.getHeader();
        block5: while (head2 != null && head2.length() > 1) {
            int pos = head2.length();
            switch (head2.substring(1, 2).charAt(0)) {
                case 'L': {
                    if (head2.indexOf("&C") >= 0) {
                        pos = Math.min(pos, head2.indexOf("&C"));
                    }
                    if (head2.indexOf("&R") >= 0) {
                        pos = Math.min(pos, head2.indexOf("&R"));
                    }
                    this.left = head2.substring(2, pos);
                    head2 = head2.substring(pos);
                    continue block5;
                }
                case 'C': {
                    if (head2.indexOf("&L") >= 0) {
                        pos = Math.min(pos, head2.indexOf("&L"));
                    }
                    if (head2.indexOf("&R") >= 0) {
                        pos = Math.min(pos, head2.indexOf("&R"));
                    }
                    this.center = head2.substring(2, pos);
                    head2 = head2.substring(pos);
                    continue block5;
                }
                case 'R': {
                    if (head2.indexOf("&C") >= 0) {
                        pos = Math.min(pos, head2.indexOf("&C"));
                    }
                    if (head2.indexOf("&L") >= 0) {
                        pos = Math.min(pos, head2.indexOf("&L"));
                    }
                    this.right = head2.substring(2, pos);
                    head2 = head2.substring(pos);
                    continue block5;
                }
            }
            head2 = null;
        }
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String newLeft) {
        this.left = newLeft;
        this.createHeaderString();
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String newCenter) {
        this.center = newCenter;
        this.createHeaderString();
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String newRight) {
        this.right = newRight;
        this.createHeaderString();
    }

    private void createHeaderString() {
        this.headerRecord.setHeader("&C" + (this.center == null ? "" : this.center) + "&L" + (this.left == null ? "" : this.left) + "&R" + (this.right == null ? "" : this.right));
        this.headerRecord.setHeaderLength((byte)this.headerRecord.getHeader().length());
    }

    public static String fontSize(short size) {
        return "&" + size;
    }

    public static String font(String font2, String style2) {
        return "&\"" + font2 + "," + style2 + "\"";
    }

    public static String page() {
        return "&P";
    }

    public static String numPages() {
        return "&N";
    }

    public static String date() {
        return "&D";
    }

    public static String time() {
        return "&T";
    }

    public static String file() {
        return "&F";
    }

    public static String tab() {
        return "&A";
    }
}

