/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.labels.XYLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class HighLowItemLabelGenerator
implements XYLabelGenerator,
XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private DateFormat dateFormatter;
    private NumberFormat numberFormatter;

    public HighLowItemLabelGenerator() {
        this(DateFormat.getInstance(), NumberFormat.getInstance());
    }

    public HighLowItemLabelGenerator(DateFormat dateFormatter, NumberFormat numberFormatter) {
        if (dateFormatter == null) {
            throw new IllegalArgumentException("Null 'dateFormatter' argument.");
        }
        if (numberFormatter == null) {
            throw new IllegalArgumentException("Null 'numberFormatter' argument.");
        }
        this.dateFormatter = dateFormatter;
        this.numberFormatter = numberFormatter;
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        String result = null;
        if (dataset instanceof HighLowDataset) {
            HighLowDataset d = (HighLowDataset)dataset;
            Number high = d.getHighValue(series, item);
            Number low = d.getLowValue(series, item);
            Number open = d.getOpenValue(series, item);
            Number close = d.getCloseValue(series, item);
            Number x = d.getXValue(series, item);
            result = d.getSeriesName(series);
            if (x != null) {
                Date date = new Date(x.longValue());
                result = result + "--> Date=" + this.dateFormatter.format(date);
                if (high != null) {
                    result = result + " High=" + this.numberFormatter.format(high.doubleValue());
                }
                if (low != null) {
                    result = result + " Low=" + this.numberFormatter.format(low.doubleValue());
                }
                if (open != null) {
                    result = result + " Open=" + this.numberFormatter.format(open.doubleValue());
                }
                if (close != null) {
                    result = result + " Close=" + this.numberFormatter.format(close.doubleValue());
                }
            }
        }
        return result;
    }

    public String generateLabel(XYDataset dataset, int series, int category) {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        HighLowItemLabelGenerator clone = (HighLowItemLabelGenerator)super.clone();
        if (this.dateFormatter != null) {
            clone.dateFormatter = (DateFormat)this.dateFormatter.clone();
        }
        if (this.numberFormatter != null) {
            clone.numberFormatter = (NumberFormat)this.numberFormatter.clone();
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HighLowItemLabelGenerator) {
            HighLowItemLabelGenerator generator = (HighLowItemLabelGenerator)o;
            if (!this.dateFormatter.equals(generator.dateFormatter)) {
                return false;
            }
            return this.numberFormatter.equals(generator.numberFormatter);
        }
        return false;
    }
}

