/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class OracleRowSetMetaData
implements RowSetMetaData,
Serializable {
    private int columnCount;
    private int[] nullable;
    private int[] columnDisplaySize;
    private int[] precision;
    private int[] scale;
    private int[] columnType;
    private boolean[] searchable;
    private boolean[] caseSensitive;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definatelyWritable;
    private boolean[] currency;
    private boolean[] autoIncrement;
    private boolean[] signed;
    private String[] columnLabel;
    private String[] schemaName;
    private String[] columnName;
    private String[] tableName;
    private String[] columnTypeName;
    private String[] catalogName;
    private String[] columnClassName;

    OracleRowSetMetaData(int n2) throws SQLException {
        this.columnCount = n2;
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        int n3 = 0;
        while (n3 < this.columnCount) {
            this.searchable[n3] = false;
            this.caseSensitive[n3] = false;
            this.readOnly[n3] = false;
            this.nullable[n3] = 1;
            this.signed[n3] = false;
            this.columnDisplaySize[n3] = 0;
            this.columnType[n3] = 0;
            this.columnLabel[n3] = "";
            this.columnName[n3] = "";
            this.schemaName[n3] = "";
            this.precision[n3] = 0;
            this.scale[n3] = 0;
            this.tableName[n3] = "";
            this.columnTypeName[n3] = "";
            this.writable[n3] = false;
            this.definatelyWritable[n3] = false;
            this.currency[n3] = false;
            this.autoIncrement[n3] = true;
            this.catalogName[n3] = "";
            this.columnClassName[n3] = "";
            ++n3;
        }
    }

    OracleRowSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.columnCount = resultSetMetaData.getColumnCount();
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        int n2 = 0;
        while (n2 < this.columnCount) {
            this.searchable[n2] = resultSetMetaData.isSearchable(n2 + 1);
            this.caseSensitive[n2] = resultSetMetaData.isCaseSensitive(n2 + 1);
            this.readOnly[n2] = resultSetMetaData.isReadOnly(n2 + 1);
            this.nullable[n2] = resultSetMetaData.isNullable(n2 + 1);
            this.signed[n2] = resultSetMetaData.isSigned(n2 + 1);
            this.columnDisplaySize[n2] = resultSetMetaData.getColumnDisplaySize(n2 + 1);
            this.columnType[n2] = resultSetMetaData.getColumnType(n2 + 1);
            this.columnLabel[n2] = resultSetMetaData.getColumnLabel(n2 + 1);
            this.columnName[n2] = resultSetMetaData.getColumnName(n2 + 1);
            this.schemaName[n2] = resultSetMetaData.getSchemaName(n2 + 1);
            if (this.columnType[n2] == 2 || this.columnType[n2] == 2 || this.columnType[n2] == -5 || this.columnType[n2] == 3 || this.columnType[n2] == 8 || this.columnType[n2] == 6 || this.columnType[n2] == 4) {
                this.precision[n2] = resultSetMetaData.getPrecision(n2 + 1);
                this.scale[n2] = resultSetMetaData.getScale(n2 + 1);
            } else {
                this.precision[n2] = 0;
                this.scale[n2] = 0;
            }
            this.tableName[n2] = resultSetMetaData.getTableName(n2 + 1);
            this.columnTypeName[n2] = resultSetMetaData.getColumnTypeName(n2 + 1);
            this.writable[n2] = resultSetMetaData.isWritable(n2 + 1);
            this.definatelyWritable[n2] = resultSetMetaData.isDefinitelyWritable(n2 + 1);
            this.currency[n2] = resultSetMetaData.isCurrency(n2 + 1);
            this.autoIncrement[n2] = resultSetMetaData.isAutoIncrement(n2 + 1);
            this.catalogName[n2] = resultSetMetaData.getCatalogName(n2 + 1);
            this.columnClassName[n2] = resultSetMetaData.getColumnClassName(n2 + 1);
            ++n2;
        }
    }

    public String getCatalogName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.catalogName[n2 - 1];
    }

    public String getColumnClassName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnClassName[n2 - 1];
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnDisplaySize[n2 - 1];
    }

    public String getColumnLabel(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnLabel[n2 - 1];
    }

    public String getColumnName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnName[n2 - 1];
    }

    public int getColumnType(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnType[n2 - 1];
    }

    public String getColumnTypeName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnTypeName[n2 - 1];
    }

    public int getPrecision(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.precision[n2 - 1];
    }

    public int getScale(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.scale[n2 - 1];
    }

    public String getSchemaName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.schemaName[n2 - 1];
    }

    public String getTableName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.tableName[n2 - 1];
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.autoIncrement[n2 - 1];
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.caseSensitive[n2 - 1];
    }

    public boolean isCurrency(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.currency[n2 - 1];
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.definatelyWritable[n2 - 1];
    }

    public int isNullable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.nullable[n2 - 1];
    }

    public boolean isReadOnly(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.readOnly[n2 - 1];
    }

    public boolean isSearchable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.searchable[n2 - 1];
    }

    public boolean isSigned(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.signed[n2 - 1];
    }

    public boolean isWritable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.writable[n2 - 1];
    }

    public void setAutoIncrement(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.autoIncrement[n2 - 1] = bl;
    }

    public void setCaseSensitive(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.caseSensitive[n2 - 1] = bl;
    }

    public void setCatalogName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.catalogName[n2 - 1] = string;
    }

    public void setColumnCount(int n2) throws SQLException {
        this.columnCount = n2;
    }

    public void setColumnDisplaySize(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnDisplaySize[n2 - 1] = n3;
    }

    public void setColumnLabel(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnLabel[n2 - 1] = string;
    }

    public void setColumnName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnName[n2 - 1] = string;
    }

    public void setColumnType(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnType[n2 - 1] = n3;
    }

    public void setColumnTypeName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnTypeName[n2 - 1] = string;
    }

    public void setCurrency(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.currency[n2 - 1] = bl;
    }

    public void setNullable(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.nullable[n2 - 1] = n3;
    }

    public void setPrecision(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.precision[n2 - 1] = n3;
    }

    public void setScale(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.scale[n2 - 1] = n3;
    }

    public void setSchemaName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.schemaName[n2 - 1] = string;
    }

    public void setSearchable(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.searchable[n2 - 1] = bl;
    }

    public void setSigned(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.signed[n2 - 1] = bl;
    }

    public void setTableName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.tableName[n2 - 1] = string;
    }

    private void validateColumnIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.columnCount) {
            throw new SQLException("Invalid column index : " + n2);
        }
    }
}

