/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker.client;

import javax.management.ObjectName;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.PayloadKey;
import org.jboss.jmx.connector.invoker.client.InvokerAdaptorException;
import org.jboss.proxy.Interceptor;

public class InvokerAdaptorClientInterceptor
extends Interceptor {
    public Object invoke(Invocation invocation) throws Throwable {
        ObjectName objectName = this.getObjectNameFromArguments(invocation);
        if (objectName != null) {
            invocation.setValue("JMX_OBJECT_NAME", objectName, PayloadKey.AS_IS);
        }
        try {
            return this.getNext().invoke(invocation);
        }
        catch (InvokerAdaptorException e) {
            throw e.getWrapped();
        }
    }

    public ObjectName getObjectNameFromArguments(Invocation invocation) {
        String method = invocation.getMethod().getName();
        if (method.equals("invoke") || method.equals("setAttribute") || method.equals("setAttributes") || method.equals("addNotificationListener") || method.equals("removeNotificationListener")) {
            return (ObjectName)invocation.getArguments()[0];
        }
        return null;
    }
}

