/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import org.opennms.protocols.snmp.SnmpAgentHandler;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpPortal;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public final class SnmpAgentSession {
    public static final int ERROR_EXCEPTION = -1;
    public static final int ERROR_INVALID_PDU = -2;
    public static final int DEFAULT_PORT = 161;
    private static final String DEFAULT_WRITE_COMMUNITY = "private";
    private int m_port;
    private SnmpPortal m_portal;
    private AsnEncoder m_encoder;
    private SnmpAgentHandler m_handler;
    private boolean m_threadException;
    private Throwable m_why;
    private SnmpPeer m_peer;

    private SnmpAgentSession() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal constructor call");
    }

    public SnmpAgentSession(SnmpAgentHandler handler) throws SocketException {
        this(handler, new SnmpPeer(null, 161));
        this.m_peer.getParameters().setWriteCommunity(DEFAULT_WRITE_COMMUNITY);
    }

    public SnmpAgentSession(SnmpAgentHandler handler, SnmpPeer peer) throws SocketException {
        this.m_peer = peer;
        this.m_port = peer.getPort();
        this.m_encoder = peer.getParameters().getEncoder();
        this.m_handler = handler;
        this.m_portal = new SnmpPortal(new AgentHandler(this), this.m_encoder, this.m_port);
        this.m_threadException = false;
        this.m_why = null;
    }

    public SnmpAgentSession(SnmpAgentHandler handler, SnmpPeer peer, int numOfThreads) throws SocketException {
        this.m_peer = peer;
        this.m_port = peer.getPort();
        this.m_encoder = peer.getParameters().getEncoder();
        this.m_handler = handler;
        this.m_portal = new SnmpPortal(new AgentHandler(this), this.m_encoder, this.m_port, null, numOfThreads);
        this.m_threadException = false;
        this.m_why = null;
    }

    public SnmpAgentHandler getHandler() {
        return this.m_handler;
    }

    public void setHandler(SnmpAgentHandler hdl) {
        this.m_handler = hdl;
    }

    public void setAsnEncoder(AsnEncoder encoder) {
        this.m_encoder = encoder;
        this.m_portal.setAsnEncoder(encoder);
    }

    public AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    public void close() {
        this.m_portal.close();
    }

    public void raise() throws Throwable {
        if (this.m_threadException) {
            throw this.m_why;
        }
    }

    public void send(SnmpPeer peer, SnmpPduPacket pdu) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        SnmpParameters parms = peer.getParameters();
        AsnEncoder encoder = parms.getEncoder();
        boolean begin = false;
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, encoder);
        SnmpOctetString community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        offset = community.encodeASN(buf, offset, encoder);
        int pivot = offset = pdu.encodeASN(buf, offset, encoder);
        offset = encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        this.m_portal.send(peer, buf, offset);
    }

    private class AgentHandler
    implements SnmpPacketHandler {
        private SnmpAgentSession m_forWhom;

        public AgentHandler(SnmpAgentSession sess) {
            this.m_forWhom = sess;
        }

        public void processSnmpMessage(InetAddress manager, int port, SnmpInt32 version, SnmpOctetString community, int pduType, SnmpPduPacket pdu) throws SnmpPduEncodingException {
            try {
                int cmd = pdu.getCommand();
                String tst = new String(community.getString());
                String rd = SnmpAgentSession.this.m_peer.getParameters().getReadCommunity();
                String wr = SnmpAgentSession.this.m_peer.getParameters().getWriteCommunity();
                switch (cmd) {
                    case 160: {
                        if (tst.equals(rd)) {
                            this.handleResponse(manager, port, pdu, SnmpAgentSession.this.m_handler.snmpReceivedGet(pdu, false));
                        }
                        break;
                    }
                    case 161: {
                        if (tst.equals(rd)) {
                            this.handleResponse(manager, port, pdu, SnmpAgentSession.this.m_handler.snmpReceivedGet(pdu, true));
                        }
                        break;
                    }
                    case 163: {
                        if (tst.equals(wr)) {
                            this.handleResponse(manager, port, pdu, SnmpAgentSession.this.m_handler.snmpReceivedSet(pdu));
                        }
                        break;
                    }
                    default: {
                        SnmpAgentSession.this.m_handler.snmpReceivedPdu(this.m_forWhom, manager, port, community, pdu);
                        break;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void handleResponse(InetAddress manager, int port, SnmpPduPacket pdu, SnmpPduRequest response) {
            if (response != null) {
                response.setRequestId(pdu.getRequestId());
                try {
                    this.m_forWhom.send(new SnmpPeer(manager, port), response);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public void processSnmpTrap(InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) throws SnmpPduEncodingException {
        }

        public void processBadDatagram(DatagramPacket p) {
        }

        public void processException(Exception e) {
            try {
                SnmpAgentSession.this.m_handler.SnmpAgentSessionError(this.m_forWhom, -1, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

