/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmNotification;
import org.jboss.monitor.alarm.MBeanImplAccess;

public class AlarmManager {
    protected MBeanImplAccess mbeanImpl;
    private Map typeMap;

    public AlarmManager(MBeanImplAccess mbeanImpl) {
        this.mbeanImpl = mbeanImpl;
        this.typeMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeverity(String type, int severity) {
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            AlarmInfo ai = (AlarmInfo)this.typeMap.get(type);
            if (ai == null) {
                this.typeMap.put(type, new AlarmInfo(severity));
            } else {
                ai.setSeverity(severity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSeverity(String type) {
        AlarmInfo ai;
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            ai = (AlarmInfo)this.typeMap.get(type);
            if (ai == null) {
                ai = new AlarmInfo(0);
                this.typeMap.put(type, ai);
            }
        }
        return ai.getSeverity();
    }

    public String getSeverityAsString(String type) {
        return Alarm.SEVERITY_STRINGS[this.getSeverity(type)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlarm(String type, int severity, String message, Object userData) {
        AlarmInfo ai;
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            ai = (AlarmInfo)this.typeMap.get(type);
            if (ai == null) {
                ai = new AlarmInfo(0);
                this.typeMap.put(type, ai);
            }
        }
        int oldSeverity = ai.getSeverity();
        if (severity != oldSeverity) {
            ai.setSeverity(severity);
            if (severity == 0) {
                this.sendAlarmNotification(type, 0, severity, message, userData);
            } else if (oldSeverity == 0) {
                this.sendAlarmNotification(type, 2, severity, message, userData);
            } else {
                this.sendAlarmNotification(type, 1, severity, message, userData);
            }
        }
    }

    public void setAlarm(String type, int severity, String message, String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        this.setAlarm(type, severity, message, map);
    }

    public void sendAlarmNotification(String type, int alarmState, int severity, String message, String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        this.sendAlarmNotification(type, alarmState, severity, message, map);
    }

    public void sendAlarmNotification(String type, int alarmState, int severity, String message, Object userData) {
        AlarmNotification n = new AlarmNotification(type, this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), message, alarmState, severity);
        n.setUserData(userData);
        this.mbeanImpl.emitNotification(n);
    }

    public void sendAttributeChangeNotification(String type, String message, Object userData, String attributeName, String attributeType, Object oldValue, Object newValue) {
        AttributeChangeNotification n = new AttributeChangeNotification(this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), message, attributeName, attributeType, oldValue, newValue);
        n.setUserData(userData);
        this.mbeanImpl.emitNotification(n);
    }

    public void sendNotification(String type, String message, Object userData) {
        Notification n = new Notification(type, this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), message);
        n.setUserData(userData);
        this.mbeanImpl.emitNotification(n);
    }

    private static class AlarmInfo {
        private int severity;

        public AlarmInfo(int severity) {
            this.severity = severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

