/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.StringTokenizer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Concept;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;

public class EnumerationHelper {
    public static Concept getConceptByPath(String path) throws IllegalArgumentException, JAXRException {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        String firstToken = "";
        if (tokenizer.hasMoreTokens() && !EnumerationHelper.checkFirstToken(firstToken = tokenizer.nextToken())) {
            throw new IllegalArgumentException("Wrong Path");
        }
        String secondToken = tokenizer.nextToken();
        return EnumerationHelper.createConcept(firstToken, secondToken);
    }

    private static boolean checkFirstToken(String token) throws IllegalArgumentException {
        if (token == null) {
            throw new IllegalArgumentException();
        }
        if (token.equalsIgnoreCase("AssociationType")) {
            return true;
        }
        if (token.equalsIgnoreCase("URLType")) {
            return true;
        }
        if (token.equalsIgnoreCase("PhoneType")) {
            return true;
        }
        if (token.equalsIgnoreCase("PostalAddressAttributes")) {
            return true;
        }
        return token.equalsIgnoreCase("ObjectType");
    }

    private static Concept createConcept(String firstToken, String secondToken) throws JAXRException {
        ClassificationSchemeImpl cs = new ClassificationSchemeImpl(null);
        cs.setName(new InternationalStringImpl(firstToken));
        ConceptImpl concept = new ConceptImpl(null);
        concept.setName(new InternationalStringImpl(secondToken.toLowerCase()));
        concept.setValue(secondToken);
        concept.setScheme(cs);
        return concept;
    }
}

