/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.Collection;
import java.util.Vector;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.ExternalIdentifierImpl;
import org.apache.ws.scout.registry.infomodel.ExternalLinkImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;
import org.apache.ws.scout.registry.infomodel.PersonNameImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.registry.infomodel.UserImpl;

public class ScoutUddiJaxrHelper {
    public static Association getAssociation(Collection orgs, LifeCycleManager lcm) throws JAXRException {
        AssociationImpl asso = new AssociationImpl(lcm);
        Object[] arr = orgs.toArray();
        asso.setSourceObject((RegistryObject)arr[0]);
        asso.setTargetObject((RegistryObject)arr[1]);
        return asso;
    }

    public static Organization getOrganization(BusinessEntity entity, LifeCycleManager lcm) throws JAXRException {
        IdentifierBag ibag;
        Vector namevect = entity.getNameVector();
        Name n = (Name)namevect.elementAt(0);
        String name = n.getValue();
        Vector descvect = entity.getDescriptionVector();
        Description desc = (Description)descvect.elementAt(0);
        OrganizationImpl org = new OrganizationImpl(lcm);
        org.setName(ScoutUddiJaxrHelper.getIString(name, lcm));
        org.setDescription(ScoutUddiJaxrHelper.getIString(desc.getValue(), lcm));
        org.setKey(lcm.createKey(entity.getBusinessKey()));
        BusinessServices services = entity.getBusinessServices();
        Vector svect = services.getBusinessServiceVector();
        for (int i = 0; svect != null && i < svect.size(); ++i) {
            BusinessService s = (BusinessService)svect.elementAt(i);
            org.addService(ScoutUddiJaxrHelper.getService(s, lcm));
        }
        Contacts contacts = entity.getContacts();
        Vector cvect = contacts.getContactVector();
        for (int i = 0; cvect != null && i < cvect.size(); ++i) {
            Contact contact = (Contact)cvect.elementAt(i);
            UserImpl user = new UserImpl(null);
            String pname = contact.getPersonName().getValue();
            user.setPersonName(new PersonNameImpl(pname));
            if (i == 0) {
                org.setPrimaryContact(user);
                continue;
            }
            org.addUser(user);
        }
        DiscoveryURLs durls = entity.getDiscoveryURLs();
        if (durls != null) {
            Vector dvect = durls.getDiscoveryURLVector();
            for (int j = 0; j < dvect.size(); ++j) {
                DiscoveryURL durl = (DiscoveryURL)dvect.elementAt(j);
                ExternalLinkImpl link = new ExternalLinkImpl(lcm);
                link.setExternalURI(durl.getValue());
                org.addExternalLink(link);
            }
        }
        if ((ibag = entity.getIdentifierBag()) != null) {
            Vector keyrvect = ibag.getKeyedReferenceVector();
            for (int i = 0; i < keyrvect.size(); ++i) {
                KeyedReference keyr = (KeyedReference)keyrvect.elementAt(i);
                ExternalIdentifierImpl eid = new ExternalIdentifierImpl(lcm);
                String kkey = keyr.getTModelKey();
                if (kkey != null) {
                    eid.setKey(new KeyImpl(kkey));
                }
                eid.setValue(keyr.getKeyValue());
                eid.setName(new InternationalStringImpl(keyr.getKeyName()));
                org.addExternalIdentifier(eid);
            }
        }
        return org;
    }

    public static Organization getOrganization(BusinessDetail bizdetail, LifeCycleManager lcm) throws JAXRException {
        IdentifierBag ibag;
        Vector bz = bizdetail.getBusinessEntityVector();
        BusinessEntity entity = (BusinessEntity)bz.elementAt(0);
        Vector namevect = entity.getNameVector();
        Name n = (Name)namevect.elementAt(0);
        String name = n.getValue();
        Vector descvect = entity.getDescriptionVector();
        Description desc = (Description)descvect.elementAt(0);
        OrganizationImpl org = new OrganizationImpl(lcm);
        org.setName(ScoutUddiJaxrHelper.getIString(name, lcm));
        org.setDescription(ScoutUddiJaxrHelper.getIString(desc.getValue(), lcm));
        org.setKey(lcm.createKey(entity.getBusinessKey()));
        BusinessServices services = entity.getBusinessServices();
        Vector svect = services.getBusinessServiceVector();
        for (int i = 0; svect != null && i < svect.size(); ++i) {
            BusinessService s = (BusinessService)svect.elementAt(i);
            org.addService(ScoutUddiJaxrHelper.getService(s, lcm));
        }
        Contacts contacts = entity.getContacts();
        Vector cvect = contacts.getContactVector();
        for (int i = 0; cvect != null && i < cvect.size(); ++i) {
            Contact contact = (Contact)cvect.elementAt(i);
            UserImpl user = new UserImpl(null);
            String pname = contact.getPersonName().getValue();
            user.setType(contact.getUseType());
            user.setPersonName(new PersonNameImpl(pname));
            if (i == 0) {
                org.setPrimaryContact(user);
                continue;
            }
            org.addUser(user);
        }
        DiscoveryURLs durls = entity.getDiscoveryURLs();
        if (durls != null) {
            Vector dvect = durls.getDiscoveryURLVector();
            for (int j = 0; j < dvect.size(); ++j) {
                DiscoveryURL durl = (DiscoveryURL)dvect.elementAt(j);
                ExternalLinkImpl link = new ExternalLinkImpl(lcm);
                link.setExternalURI(durl.getValue());
                org.addExternalLink(link);
            }
        }
        if ((ibag = entity.getIdentifierBag()) != null) {
            Vector keyrvect = ibag.getKeyedReferenceVector();
            for (int i = 0; i < keyrvect.size(); ++i) {
                KeyedReference keyr = (KeyedReference)keyrvect.elementAt(i);
                ExternalIdentifierImpl eid = new ExternalIdentifierImpl(lcm);
                String kkey = keyr.getTModelKey();
                if (kkey != null) {
                    eid.setKey(new KeyImpl(kkey));
                }
                eid.setValue(keyr.getKeyValue());
                eid.setName(new InternationalStringImpl(keyr.getKeyName()));
                org.addExternalIdentifier(eid);
            }
        }
        return org;
    }

    public static InternationalString getIString(String str, LifeCycleManager blm) throws JAXRException {
        return blm.createInternationalString(str);
    }

    public static Service getService(BusinessService bs, LifeCycleManager lcm) throws JAXRException {
        ServiceImpl serve = new ServiceImpl(lcm);
        String keystr = bs.getServiceKey();
        if (keystr != null) {
            serve.setKey(lcm.createKey(keystr));
        }
        Vector namevect = bs.getNameVector();
        Name n = (Name)namevect.elementAt(0);
        String name = n.getValue();
        serve.setName(lcm.createInternationalString(name));
        Vector descvect = bs.getDescriptionVector();
        Description desc = (Description)descvect.elementAt(0);
        serve.setDescription(lcm.createInternationalString(desc.getValue()));
        return serve;
    }

    public static Service getService(ServiceInfo si, LifeCycleManager lcm) throws JAXRException {
        ServiceImpl service = new ServiceImpl(lcm);
        String keystr = si.getServiceKey();
        if (keystr != null) {
            service.setKey(lcm.createKey(keystr));
        }
        Vector namevect = si.getNameVector();
        Name n = (Name)namevect.elementAt(0);
        String name = n.getValue();
        service.setName(lcm.createInternationalString(name));
        return service;
    }

    public static ServiceBinding getServiceBinding(BindingTemplate bs, LifeCycleManager lcm) throws JAXRException {
        Vector dv;
        AccessPoint access;
        ServiceBindingImpl serve = new ServiceBindingImpl(lcm);
        TModelInstanceDetails details = bs.getTModelInstanceDetails();
        Vector tiv = details.getTModelInstanceInfoVector();
        for (int i = 0; tiv != null && i < tiv.size(); ++i) {
            TModelInstanceInfo info = (TModelInstanceInfo)tiv.elementAt(i);
        }
        String keystr = bs.getServiceKey();
        if (keystr != null) {
            ServiceImpl svc = new ServiceImpl(lcm);
            svc.setKey(lcm.createKey(keystr));
            serve.setService(svc);
        }
        if ((access = bs.getAccessPoint()) != null) {
            serve.setAccessURI(access.getURL());
        }
        if ((dv = bs.getDescriptionVector()) != null) {
            Description des = (Description)dv.elementAt(0);
            serve.setDescription(new InternationalStringImpl(des.getValue()));
        }
        return serve;
    }

    public static Concept getConcept(TModelDetail tm, LifeCycleManager lcm) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lcm);
        Vector tc = tm.getTModelVector();
        TModel tmodel = (TModel)tc.elementAt(0);
        concept.setKey(lcm.createKey(tmodel.getTModelKey()));
        concept.setName(lcm.createInternationalString(tmodel.getName()));
        Vector descvect = tmodel.getDescriptionVector();
        Description desc = (Description)descvect.elementAt(0);
        concept.setDescription(lcm.createInternationalString(desc.getValue()));
        return concept;
    }

    public static Concept getConcept(TModel tmodel, LifeCycleManager lcm) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lcm);
        concept.setKey(lcm.createKey(tmodel.getTModelKey()));
        concept.setName(lcm.createInternationalString(tmodel.getName()));
        Vector descvect = tmodel.getDescriptionVector();
        Description desc = (Description)descvect.elementAt(0);
        concept.setDescription(lcm.createInternationalString(desc.getValue()));
        return concept;
    }

    public static Concept getConcept(TModelInfo tm, LifeCycleManager lcm) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lcm);
        concept.setKey(lcm.createKey(tm.getTModelKey()));
        concept.setName(lcm.createInternationalString(tm.getName().getValue()));
        return concept;
    }
}

