/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client.impl;

import com.google.gwt.junit.client.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PermutationIterator
implements Iterator {
    private boolean firstRun = true;
    private List iterators;
    private boolean maybeHaveMore = true;
    private List ranges;
    private boolean rangeSkipped = false;
    private List values;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) {
        List<Range> ranges = Arrays.asList(new ListRange(Arrays.asList("a", "b", "c")), new ListRange(Arrays.asList("1", "2", "3")), new ListRange(Arrays.asList("alpha", "beta", "gamma", "delta")));
        System.out.println("Testing normal iteration.");
        PermutationIterator it = new PermutationIterator(ranges);
        while (it.hasNext()) {
            Permutation p = (Permutation)it.next();
            System.out.println(p);
        }
        System.out.println("\nTesting skipping iteration.");
        Iterator<String> skipIterator = Arrays.asList("alpha", "beta", "gamma", "delta").iterator();
        boolean skipped = true;
        String skipValue = null;
        PermutationIterator it2 = new PermutationIterator(ranges);
        while (it2.hasNext()) {
            Permutation p = (Permutation)it2.next();
            if (skipped && skipIterator.hasNext()) {
                skipValue = skipIterator.next();
                skipped = false;
            }
            System.out.println(p);
            String value = (String)p.getValues().get(p.getValues().size() - 1);
            if (!value.equals(skipValue)) continue;
            it2.skipCurrentRange();
            skipped = true;
        }
    }

    public PermutationIterator(List ranges) {
        this.ranges = ranges;
        this.iterators = new ArrayList();
        for (int i = 0; i < ranges.size(); ++i) {
            Range r = (Range)ranges.get(i);
            this.iterators.add(r.iterator());
        }
        this.values = new ArrayList();
    }

    public boolean hasNext() {
        if (!this.maybeHaveMore) {
            return false;
        }
        for (int currentIterator = this.iterators.size() - 1; currentIterator >= 0; --currentIterator) {
            Iterator it = (Iterator)this.iterators.get(currentIterator);
            if (!it.hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        if (!$assertionsDisabled && !this.hasNext()) {
            throw new AssertionError((Object)"No more available permutations in this iterator.");
        }
        if (this.firstRun) {
            for (int i = 0; i < this.iterators.size(); ++i) {
                Iterator it = (Iterator)this.iterators.get(i);
                this.values.add(it.next());
            }
            this.firstRun = false;
            return new Permutation(this.values);
        }
        if (this.rangeSkipped) {
            this.rangeSkipped = false;
            return new Permutation(this.values);
        }
        for (int currentIteratorIndex = this.iterators.size() - 1; currentIteratorIndex >= 0; --currentIteratorIndex) {
            Iterator it = (Iterator)this.iterators.get(currentIteratorIndex);
            if (!it.hasNext()) continue;
            this.values.set(currentIteratorIndex, it.next());
            for (int i = currentIteratorIndex + 1; i < this.iterators.size(); ++i) {
                Range resetRange = (Range)this.ranges.get(i);
                Iterator resetIterator = resetRange.iterator();
                this.iterators.set(i, resetIterator);
                this.values.set(i, resetIterator.next());
            }
            return new Permutation(this.values);
        }
        throw new AssertionError((Object)"Assertion failed - Couldn't find a non-empty iterator.");
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skipCurrentRange() {
        this.rangeSkipped = true;
        for (int currentIteratorIndex = this.iterators.size() - 2; currentIteratorIndex >= 0; --currentIteratorIndex) {
            Iterator it = (Iterator)this.iterators.get(currentIteratorIndex);
            if (!it.hasNext()) continue;
            this.values.set(currentIteratorIndex, it.next());
            for (int i = currentIteratorIndex + 1; i < this.iterators.size(); ++i) {
                Range resetRange = (Range)this.ranges.get(i);
                Iterator resetIterator = resetRange.iterator();
                this.iterators.set(i, resetIterator);
                this.values.set(i, resetIterator.next());
            }
            return;
        }
        this.maybeHaveMore = false;
    }

    static {
        $assertionsDisabled = !PermutationIterator.class.desiredAssertionStatus();
    }

    private static class ListRange
    implements Range {
        private List list;

        public ListRange(List list) {
            this.list = list;
        }

        public Iterator iterator() {
            return this.list.iterator();
        }
    }

    public static class Permutation {
        private List values;

        public Permutation(List values) {
            this.values = new ArrayList(values);
        }

        public List getValues() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }
    }
}

