/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.Iterator;

public abstract class ComplexPanel
extends Panel
implements IndexedPanel {
    private WidgetCollection children = new WidgetCollection(this);

    public Widget getWidget(int index) {
        return this.getChildren().get(index);
    }

    public int getWidgetCount() {
        return this.getChildren().size();
    }

    public int getWidgetIndex(Widget child) {
        return this.getChildren().indexOf(child);
    }

    public Iterator iterator() {
        return this.getChildren().iterator();
    }

    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    public boolean remove(Widget w) {
        if (w.getParent() != this) {
            return false;
        }
        this.orphan(w);
        Element elem = w.getElement();
        DOM.removeChild(DOM.getParent(elem), elem);
        this.getChildren().remove(w);
        return true;
    }

    protected void add(Widget child, Element container) {
        child.removeFromParent();
        this.getChildren().add(child);
        DOM.appendChild(container, child.getElement());
        this.adopt(child);
    }

    protected int adjustIndex(Widget child, int beforeIndex) {
        int idx;
        this.checkIndexBoundsForInsertion(beforeIndex);
        if (child.getParent() == this && (idx = this.getWidgetIndex(child)) < beforeIndex) {
            --beforeIndex;
        }
        return beforeIndex;
    }

    protected void checkIndexBoundsForAccess(int index) {
        if (index < 0 || index >= this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkIndexBoundsForInsertion(int index) {
        if (index < 0 || index > this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected WidgetCollection getChildren() {
        return this.children;
    }

    protected void insert(Widget child, Element container, int beforeIndex) {
        if (container == null) {
            throw new NullPointerException("container may not be null");
        }
        this.insert(child, container, beforeIndex, false);
    }

    protected void insert(Widget child, Element container, int beforeIndex, boolean domInsert) {
        beforeIndex = this.adjustIndex(child, beforeIndex);
        child.removeFromParent();
        this.getChildren().insert(child, beforeIndex);
        if (domInsert) {
            DOM.insertChild(container, child.getElement(), beforeIndex);
        } else {
            DOM.appendChild(container, child.getElement());
        }
        this.adopt(child);
    }
}

