/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

public class DockPanel
extends CellPanel
implements HasAlignment {
    public static final DockLayoutConstant CENTER = new DockLayoutConstant();
    public static final DockLayoutConstant EAST = new DockLayoutConstant();
    public static final DockLayoutConstant NORTH = new DockLayoutConstant();
    public static final DockLayoutConstant SOUTH = new DockLayoutConstant();
    public static final DockLayoutConstant WEST = new DockLayoutConstant();
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign = ALIGN_LEFT;
    private HasVerticalAlignment.VerticalAlignmentConstant vertAlign = ALIGN_TOP;
    private Widget center;

    public DockPanel() {
        DOM.setElementPropertyInt(this.getTable(), "cellSpacing", 0);
        DOM.setElementPropertyInt(this.getTable(), "cellPadding", 0);
    }

    public void add(Widget widget, DockLayoutConstant direction) {
        if (direction == CENTER) {
            if (widget == this.center) {
                return;
            }
            if (this.center != null) {
                throw new IllegalArgumentException("Only one CENTER widget may be added");
            }
        }
        widget.removeFromParent();
        this.getChildren().add(widget);
        if (direction == CENTER) {
            this.center = widget;
        }
        LayoutData layout = new LayoutData(direction);
        widget.setLayoutData(layout);
        this.setCellHorizontalAlignment(widget, this.horzAlign);
        this.setCellVerticalAlignment(widget, this.vertAlign);
        this.realizeTable();
        this.adopt(widget);
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public HasVerticalAlignment.VerticalAlignmentConstant getVerticalAlignment() {
        return this.vertAlign;
    }

    public DockLayoutConstant getWidgetDirection(Widget w) {
        if (w.getParent() != this) {
            return null;
        }
        return ((LayoutData)w.getLayoutData()).direction;
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            if (w == this.center) {
                this.center = null;
            }
            this.realizeTable();
        }
        return removed;
    }

    public void setCellHeight(Widget w, String height) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.height = height;
        if (data.td != null) {
            DOM.setStyleAttribute(data.td, "height", data.height);
        }
    }

    public void setCellHorizontalAlignment(Widget w, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.hAlign = align.getTextAlignString();
        if (data.td != null) {
            DOM.setElementProperty(data.td, "align", data.hAlign);
        }
    }

    public void setCellVerticalAlignment(Widget w, HasVerticalAlignment.VerticalAlignmentConstant align) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.vAlign = align.getVerticalAlignString();
        if (data.td != null) {
            DOM.setStyleAttribute(data.td, "verticalAlign", data.vAlign);
        }
    }

    public void setCellWidth(Widget w, String width) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.width = width;
        if (data.td != null) {
            DOM.setStyleAttribute(data.td, "width", data.width);
        }
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
    }

    public void setVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant align) {
        this.vertAlign = align;
    }

    private void realizeTable() {
        Element bodyElem = this.getBody();
        while (DOM.getChildCount(bodyElem) > 0) {
            DOM.removeChild(bodyElem, DOM.getChild(bodyElem, 0));
        }
        int rowCount = 1;
        int colCount = 1;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Widget child = (Widget)it.next();
            DockLayoutConstant dir = ((LayoutData)child.getLayoutData()).direction;
            if (dir == NORTH || dir == SOUTH) {
                ++rowCount;
                continue;
            }
            if (dir != EAST && dir != WEST) continue;
            ++colCount;
        }
        TmpRow[] rows = new TmpRow[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = new TmpRow();
            rows[i].tr = DOM.createTR();
            DOM.appendChild(bodyElem, rows[i].tr);
        }
        int westCol = 0;
        int eastCol = colCount - 1;
        int northRow = 0;
        int southRow = rowCount - 1;
        Element centerTd = null;
        Iterator it2 = this.getChildren().iterator();
        while (it2.hasNext()) {
            TmpRow row;
            Element td;
            Widget child = (Widget)it2.next();
            LayoutData layout = (LayoutData)child.getLayoutData();
            layout.td = td = DOM.createTD();
            DOM.setElementProperty(layout.td, "align", layout.hAlign);
            DOM.setStyleAttribute(layout.td, "verticalAlign", layout.vAlign);
            DOM.setElementProperty(layout.td, "width", layout.width);
            DOM.setElementProperty(layout.td, "height", layout.height);
            if (layout.direction == NORTH) {
                DOM.insertChild(rows[northRow].tr, td, rows[northRow].center);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "colSpan", eastCol - westCol + 1);
                ++northRow;
                continue;
            }
            if (layout.direction == SOUTH) {
                DOM.insertChild(rows[southRow].tr, td, rows[southRow].center);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "colSpan", eastCol - westCol + 1);
                --southRow;
                continue;
            }
            if (layout.direction == WEST) {
                row = rows[northRow];
                DOM.insertChild(row.tr, td, row.center++);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "rowSpan", southRow - northRow + 1);
                ++westCol;
                continue;
            }
            if (layout.direction == EAST) {
                row = rows[northRow];
                DOM.insertChild(row.tr, td, row.center);
                DOM.appendChild(td, child.getElement());
                DOM.setElementPropertyInt(td, "rowSpan", southRow - northRow + 1);
                --eastCol;
                continue;
            }
            if (layout.direction != CENTER) continue;
            centerTd = td;
        }
        if (this.center != null) {
            TmpRow row = rows[northRow];
            DOM.insertChild(row.tr, centerTd, row.center);
            DOM.appendChild(centerTd, this.center.getElement());
        }
    }

    private static class TmpRow {
        public int center;
        public Element tr;

        private TmpRow() {
        }
    }

    static class LayoutData {
        public DockLayoutConstant direction;
        public String hAlign = "left";
        public String height = "";
        public Element td;
        public String vAlign = "top";
        public String width = "";

        public LayoutData(DockLayoutConstant dir) {
            this.direction = dir;
        }
    }

    public static class DockLayoutConstant {
        private DockLayoutConstant() {
        }
    }
}

