/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.BorderInfo;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class BorderHelper
extends BaseHelper {
    public BorderHelper(Writer writer) {
        super(writer);
    }

    public void export(JRLineBox box) throws IOException {
        if (box != null) {
            this.export(new BorderInfo(box));
        }
    }

    public void export(JRPen pen) throws IOException {
        if (pen != null) {
            this.export(new BorderInfo(pen));
        }
    }

    private void export(BorderInfo info) throws IOException {
        if (info.hasBorder()) {
            this.writer.write("      <w:tcBorders>\n");
            this.exportBorder(info, 0);
            this.exportBorder(info, 1);
            this.exportBorder(info, 2);
            this.exportBorder(info, 3);
            this.writer.write("      </w:tcBorders>\n");
        }
        this.writer.write("      <w:tcMar>\n");
        this.exportPadding(info, 0);
        this.exportPadding(info, 1);
        this.exportPadding(info, 2);
        this.exportPadding(info, 3);
        this.writer.write("      </w:tcMar>\n");
    }

    private void exportBorder(BorderInfo info, int side) throws IOException {
        if (info.borderWidth[side] != null) {
            this.writer.write("<w:" + BorderInfo.BORDER[side] + " w:val=\"" + info.borderStyle[side] + "\" w:sz=\"" + info.borderWidth[side] + "\" w:space=\"0\"");
            if (info.borderColor[side] != null) {
                this.writer.write(" w:color=\"" + JRColorUtil.getColorHexa(info.borderColor[side]) + "\"");
            }
            this.writer.write(" />\n");
        }
    }

    private void exportPadding(BorderInfo info, int side) throws IOException {
        if (info.borderPadding[side] != null) {
            this.writer.write("       <w:" + BorderInfo.BORDER[side] + " w:w=\"" + info.borderPadding[side] + "\" w:type=\"dxa\" />\n");
        }
    }
}

