/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.referenceable.ObjectRefAddr;

public class SpyConnectionFactory
implements Serializable,
ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable {
    static final long serialVersionUID = 3392566934963731105L;
    protected GenericConnectionFactory factory;

    public SpyConnectionFactory(GenericConnectionFactory factory) {
        this.factory = factory;
    }

    public SpyConnectionFactory(Properties config) {
        this.factory = new GenericConnectionFactory(null, config);
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.mq.SpyConnectionFactory", new ObjectRefAddr("DCF", this.factory), "org.jboss.mq.referenceable.SpyConnectionFactoryObjectFactory", null);
    }

    public Connection createConnection() throws JMSException {
        try {
            return new SpyConnection(this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Failed to create Connection", e);
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        try {
            if (userName == null) {
                throw new SpyJMSException("Username is null");
            }
            if (password == null) {
                throw new SpyJMSException("Password is null");
            }
            return new SpyConnection(userName, password, this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Failed to create Connection", e);
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }
}

