/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.persistence;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.persistence.AttributePersistenceManager;
import org.jboss.mx.persistence.PersistenceManager;

public class DelegatingPersistenceManager
implements PersistenceManager {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mx$persistence$DelegatingPersistenceManager == null ? (class$org$jboss$mx$persistence$DelegatingPersistenceManager = DelegatingPersistenceManager.class$("org.jboss.mx.persistence.DelegatingPersistenceManager")) : class$org$jboss$mx$persistence$DelegatingPersistenceManager));
    private AttributePersistenceManager persistor;
    private String persistName;
    private boolean isLoading;
    static /* synthetic */ Class class$org$jboss$mx$persistence$DelegatingPersistenceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ModelMBeanInvoker invoker, MBeanInfo metadata) throws MBeanException {
        if (this.persistor == null) {
            this.init(invoker, metadata);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("load() called for: '" + this.persistName + "'"));
        }
        AttributeList attrs = null;
        try {
            attrs = this.persistor.load(this.persistName);
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception while loading", (Throwable)e);
            throw new MBeanException(e);
        }
        if (attrs != null) {
            try {
                this.setIsLoading(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading attributes: " + attrs));
                }
                invoker.setAttributes(attrs);
            }
            finally {
                this.setIsLoading(false);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No attributes to load");
        }
    }

    public void store(MBeanInfo metadata) throws MBeanException {
        if (this.persistor == null) {
            throw new MBeanException(new Exception("store() called before instance initialized"));
        }
        if (this.isLoading()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("store() called for: '" + this.persistName + "'"));
        }
        AttributeList attributes = new AttributeList();
        MBeanAttributeInfo[] attrs = metadata.getAttributes();
        if (log.isDebugEnabled() && attrs.length > 0) {
            log.debug((Object)"store() --- ModelMBeanAttributeInfo[] ---");
        }
        for (int i = 0; i < attrs.length; ++i) {
            boolean noPersistPolicy;
            ModelMBeanAttributeInfo attributeInfo = (ModelMBeanAttributeInfo)attrs[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("  attr (#" + i + ") - " + attributeInfo));
            }
            if (!attributeInfo.isWritable()) continue;
            Descriptor attrDesc = attributeInfo.getDescriptor();
            Object name = attrDesc.getFieldValue("name");
            Object value = attrDesc.getFieldValue("attributeValue");
            Object updated = attrDesc.getFieldValue("lastUpdatedTimeStamp2");
            Object pPolicy = attrDesc.getFieldValue("persistPolicy");
            boolean bl = noPersistPolicy = pPolicy != null && ((String)pPolicy).equalsIgnoreCase("Never");
            if (updated == null || noPersistPolicy) continue;
            attributes.add(new Attribute(name.toString(), value));
        }
        try {
            if (!attributes.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("calling persistor.store(" + this.persistName + ") attrs=" + attributes));
                }
                this.persistor.store(this.persistName, attributes);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"nothing to persist");
            }
        }
        catch (Exception e) {
            log.warn((Object)"cought exception during store()", (Throwable)e);
        }
    }

    protected void init(ModelMBeanInvoker invoker, MBeanInfo metadata) throws MBeanException {
        String operation;
        String service;
        String name;
        Descriptor desc = ((ModelMBeanInfo)((Object)metadata)).getMBeanDescriptor();
        if (log.isDebugEnabled()) {
            log.debug((Object)"init() --- ModelMBeanInfo Descriptor --- ");
            log.debug((Object)desc);
        }
        if ((name = (String)desc.getFieldValue("persistName")) != null) {
            this.persistName = name;
        } else {
            ObjectName objectName = (ObjectName)desc.getFieldValue("objectname");
            if (objectName != null) {
                this.persistName = objectName.toString();
            } else {
                throw new MBeanException(new Exception("must specify a value for: persistName"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("chosen persistent id: '" + this.persistName + "'"));
        }
        if ((service = (String)desc.getFieldValue("attribute-persistence-service")) == null) {
            service = "jboss:service=AttributePersistenceService";
        }
        if ((operation = (String)desc.getFieldValue("attribute-persistence-operation")) == null) {
            operation = "apmCreate";
        }
        try {
            ObjectName objName = new ObjectName(service);
            MBeanServer server = invoker.getServer();
            this.persistor = (AttributePersistenceManager)server.invoke(objName, operation, new Object[0], new String[0]);
            if (this.persistor == null) {
                throw new MBeanException(new NullPointerException("null AttributePersistenceManager from: " + service));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanException(e, "not a valid ObjectName: " + service);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e, "service not registered: " + service);
        }
        catch (ReflectionException e) {
            throw new MBeanException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("using AttributePersistenceManager: " + this.persistor.getClass().getName()));
        }
    }

    protected boolean isLoading() {
        return this.isLoading;
    }

    protected void setIsLoading(boolean newIsLoading) {
        this.isLoading = newIsLoading;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

