/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.grid.ed;

import com.ampiere.dto.CodeValue;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.model.GridTab;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.ValueNamePair;

public class WPayment {
    private int m_WindowNo = 0;
    private GridTab m_mTab;
    private String m_DocStatus = null;
    private String m_PaymentRule = "";
    private int m_C_PaymentTerm_ID = 0;
    private Timestamp m_DateAcct = null;
    private int m_C_Payment_ID = 0;
    private MPayment m_mPayment = null;
    private MPayment m_mPaymentOriginal = null;
    private int m_C_CashLine_ID = 0;
    private MCashLine m_cashLine = null;
    private String m_CCType = "";
    private int m_C_BankAccount_ID = 0;
    private int m_C_CashBook_ID = 0;
    private boolean m_isSOTrx = true;
    private int m_C_Currency_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_C_BPartner_ID = 0;
    private BigDecimal m_Amount = Env.ZERO;
    private boolean m_initOK = false;
    private boolean m_onlyRule = false;
    private static Hashtable<Integer, CodeValue> s_Currencies = null;
    private boolean m_needSave = false;
    private static CLogger log = CLogger.getCLogger(WPayment.class);
    private ArrayList<CodeValue> paymentCombo = new ArrayList();
    private String paymentComboSelected = "";
    private ArrayList<CodeValue> kTypeCombo = new ArrayList();
    private String kTypeComboSelected = "";
    private String kNumberField = "";
    private String kExpField = "";
    private ArrayList<CodeValue> tAccountCombo = new ArrayList();
    private String sNumberField = "";
    private String sRoutingField = "";
    private ArrayList<CodeValue> sCurrencyCombo = new ArrayList();
    private ArrayList<CodeValue> bCurrencyCombo = new ArrayList();
    private ArrayList<CodeValue> pTermCombo = new ArrayList();
    private String pTermComboSelected = "";
    private String sCheckField = "";
    private ArrayList<CodeValue> sBankAccountCombo = new ArrayList();
    private String sBankAccountComboSelected = "";
    private ArrayList<CodeValue> bCashBookCombo = new ArrayList();
    private String bCashBookComboSelected = "";
    private String tRoutingField = "";
    private String tNumberField = "";

    public WPayment(int WindowNo, GridTab mTab, Ctx ctx) {
        this.m_WindowNo = WindowNo;
        this.m_isSOTrx = "Y".equals(ctx.getContext(WindowNo, "IsSOTrx"));
        this.m_mTab = mTab;
        try {
            this.jbInit(ctx);
            this.m_initOK = this.dynInit(ctx);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WPayment", ex);
            this.m_initOK = false;
        }
    }

    private void jbInit(Ctx ctx) throws Exception {
    }

    private boolean dynInit(Ctx ctx) throws Exception {
        KeyNamePair pp;
        String name;
        ResultSet rs;
        CPreparedStatement pstmt;
        CodeValue pp2;
        String name2;
        int key;
        ResultSet rs2;
        CPreparedStatement pstmt2;
        Integer C_Currency_ID;
        this.m_DocStatus = (String)this.m_mTab.getValue("DocStatus");
        log.config(this.m_DocStatus);
        if (this.m_mTab.getValue("C_BPartner_ID") == null) {
            log.log(Level.SEVERE, Msg.translate(ctx, "SaveErrorRowNotFound"));
            return false;
        }
        this.m_DocStatus = (String)this.m_mTab.getValue("DocStatus");
        if (this.m_DocStatus == null) {
            this.m_DocStatus = "";
        }
        if (this.m_DocStatus.equals("RE") || this.m_DocStatus.equals("VO") || this.m_DocStatus.equals("CL")) {
            return false;
        }
        this.m_onlyRule = !this.m_DocStatus.equals("CO") && !this.m_DocStatus.equals("WP");
        if (!this.m_onlyRule && !this.m_isSOTrx && this.m_mTab.getValue("M_Warehouse_ID") != null) {
            this.m_onlyRule = true;
        }
        this.m_Amount = (BigDecimal)this.m_mTab.getValue("GrandTotal");
        if (!this.m_onlyRule && this.m_Amount.compareTo(Env.ZERO) == 0) {
            log.log(Level.SEVERE, Msg.translate(ctx, "PaymentZero"));
            return false;
        }
        if (s_Currencies == null) {
            this.loadCurrencies();
        }
        if (s_Currencies.containsKey(C_Currency_ID = new Integer(this.m_C_Currency_ID))) {
            Enumeration<Integer> en = s_Currencies.keys();
            while (en.hasMoreElements()) {
                Integer key2 = en.nextElement();
                this.bCurrencyCombo.add(s_Currencies.get(key2));
                this.sCurrencyCombo.add(s_Currencies.get(key2));
            }
            if (s_Currencies.get(C_Currency_ID) != null) {
                // empty if block
            }
        }
        if (this.m_PaymentRule == null) {
            this.m_PaymentRule = "";
        }
        CodeValue vp = null;
        HashMap values = (HashMap)this.readReference(195, ctx);
        Object[] a = values.keySet().toArray();
        for (int i = 0; i < a.length; ++i) {
            String PaymentRule = (String)a[i];
            CodeValue pp3 = new CodeValue(PaymentRule, (String)values.get(a[i]));
            this.paymentCombo.add(pp3);
            if (!PaymentRule.toString().equals(this.m_PaymentRule)) continue;
            vp = pp3;
        }
        if (vp != null) {
            this.paymentComboSelected = vp.getCode();
        }
        String SQL = MRole.getDefault(ctx, false).addAccessSQL("SELECT C_PaymentTerm_ID, Name FROM C_PaymentTerm WHERE IsActive='Y' ORDER BY Name", "C_PaymentTerm", false, false);
        CodeValue kp = null;
        try {
            pstmt2 = DB.prepareStatement(SQL, null);
            rs2 = pstmt2.executeQuery();
            while (rs2.next()) {
                key = rs2.getInt(1);
                name2 = rs2.getString(2);
                pp2 = new CodeValue(Integer.toString(key), name2);
                this.pTermCombo.add(pp2);
                if (key != this.m_C_PaymentTerm_ID) continue;
                kp = pp2;
            }
            rs2.close();
            pstmt2.close();
        }
        catch (SQLException ept) {
            log.log(Level.SEVERE, SQL, ept);
        }
        if (kp != null) {
            this.pTermComboSelected = kp.getCode();
        }
        SQL = "SELECT a.C_BP_BankAccount_ID, NVL(b.Name, ' ')||a.AccountNo AS Acct FROM C_BP_BankAccount a,C_Bank b WHERE C_BPartner_ID=? AND a.IsActive='Y'";
        kp = null;
        try {
            pstmt2 = DB.prepareStatement(SQL, null);
            pstmt2.setInt(1, this.m_C_BPartner_ID);
            rs2 = pstmt2.executeQuery();
            while (rs2.next()) {
                key = rs2.getInt(1);
                name2 = rs2.getString(2);
                pp2 = new CodeValue(Integer.toString(key), name2);
                this.tAccountCombo.add(pp2);
            }
            rs2.close();
            pstmt2.close();
        }
        catch (SQLException eac) {
            log.log(Level.SEVERE, SQL, eac);
        }
        ValueNamePair[] ccs = this.m_mPayment.getCreditCards();
        String selVal = null;
        for (int i = 0; i < ccs.length; ++i) {
            this.kTypeCombo.add(new CodeValue(ccs[i].getValue(), ccs[i].getName()));
            if (!ccs[i].getValue().equals(this.m_CCType)) continue;
            selVal = ccs[i].getValue();
        }
        if (selVal != null) {
            this.kTypeComboSelected = selVal;
        }
        SQL = MRole.getDefault(ctx, false).addAccessSQL("SELECT C_BankAccount_ID, Name || ' ' || AccountNo, IsDefault FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE b.IsActive='Y'", "ba", true, false);
        selVal = null;
        try {
            pstmt = DB.prepareStatement(SQL, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int key3 = rs.getInt(1);
                name = rs.getString(2);
                pp = new KeyNamePair(key3, name);
                this.sBankAccountCombo.add(new CodeValue(Integer.toString(pp.getKey()), pp.getName()));
                if (key3 == this.m_C_BankAccount_ID) {
                    selVal = Integer.toString(pp.getKey());
                }
                if (kp != null || !rs.getString(3).equals("Y")) continue;
                selVal = Integer.toString(pp.getKey());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ept) {
            log.log(Level.SEVERE, SQL, ept);
        }
        if (selVal != null) {
            this.sBankAccountComboSelected = selVal;
        }
        SQL = MRole.getDefault(ctx, false).addAccessSQL("SELECT C_CashBook_ID, Name, AD_Org_ID FROM C_CashBook WHERE IsActive='Y'", "C_CashBook", false, false);
        selVal = null;
        try {
            pstmt = DB.prepareStatement(SQL, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int key4 = rs.getInt(1);
                name = rs.getString(2);
                pp = new KeyNamePair(key4, name);
                this.bCashBookCombo.add(new CodeValue(Integer.toString(pp.getKey()), pp.getName()));
                if (key4 == this.m_C_CashBook_ID) {
                    selVal = Integer.toString(pp.getKey());
                }
                if (kp != null || key4 != this.m_AD_Org_ID) continue;
                selVal = Integer.toString(pp.getKey());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException epc) {
            log.log(Level.SEVERE, SQL, epc);
        }
        if (selVal != null) {
            this.bCashBookComboSelected = selVal;
            if (this.m_C_CashBook_ID == 0) {
                this.m_C_CashBook_ID = Integer.parseInt(selVal);
            }
        }
        return true;
    }

    public boolean isInitOK() {
        return this.m_initOK;
    }

    private void loadCurrencies() {
        s_Currencies = new Hashtable(12);
        String SQL = "SELECT C_Currency_ID, ISO_Code FROM C_Currency WHERE (IsEMUMember='Y' AND EMUEntryDate<SysDate) OR IsEuro='Y' ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String name = rs.getString(2);
                s_Currencies.put(id, new CodeValue(Integer.toString(id), name));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
    }

    public void actionPerformed() {
    }

    protected boolean saveChanges(Ctx ctx) {
        String kp;
        String newPaymentRule = this.paymentComboSelected;
        log.info("New Rule: " + newPaymentRule);
        if (this.m_onlyRule) {
            if (!newPaymentRule.equals(this.m_PaymentRule)) {
                this.m_mTab.setValue("PaymentRule", (Object)newPaymentRule);
            }
            return true;
        }
        Timestamp newDateAcct = this.m_DateAcct;
        int newC_PaymentTerm_ID = this.m_C_PaymentTerm_ID;
        int newC_CashLine_ID = this.m_C_CashLine_ID;
        int newC_CashBook_ID = this.m_C_CashBook_ID;
        String newCCType = this.m_CCType;
        int newC_BankAccount_ID = 0;
        if (newPaymentRule.equals("B")) {
            kp = this.bCashBookComboSelected;
            if (kp != null) {
                newC_CashBook_ID = Integer.parseInt(kp);
            }
        } else if (newPaymentRule.equals("K")) {
            String vp = this.kTypeComboSelected;
            if (vp != null) {
                newCCType = vp;
            }
        } else if (!newPaymentRule.equals("T") && !newPaymentRule.equals("D")) {
            if (newPaymentRule.equals("P")) {
                kp = this.pTermComboSelected;
                if (kp != null) {
                    newC_PaymentTerm_ID = Integer.parseInt(kp);
                }
            } else if (newPaymentRule.equals("S")) {
                kp = this.sBankAccountComboSelected;
                if (kp != null) {
                    newC_BankAccount_ID = Integer.parseInt(kp);
                }
            } else {
                kp = this.pTermComboSelected;
                if (kp != null) {
                    newC_PaymentTerm_ID = Integer.parseInt(kp);
                }
            }
        }
        if ("KTSD".indexOf(newPaymentRule) == -1 || newC_BankAccount_ID == 0) {
            // empty if block
        }
        if (!newPaymentRule.equals(this.m_PaymentRule)) {
            log.fine("Changed PaymentRule: " + this.m_PaymentRule + " -> " + newPaymentRule);
            if (this.m_PaymentRule.equals("B")) {
                log.fine("Old Cash - " + this.m_cashLine);
                if (this.m_cashLine != null) {
                    MCashLine cl = this.m_cashLine.createReversal();
                    if (cl.save()) {
                        log.config("CashCancelled");
                    } else {
                        log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
                    }
                }
                newC_CashLine_ID = 0;
            } else if ("KTSD".indexOf(this.m_PaymentRule) != -1 && "KTSD".indexOf(newPaymentRule) != -1 && this.m_mPaymentOriginal != null) {
                log.fine("Old Payment(1) - " + this.m_mPaymentOriginal);
                this.m_mPaymentOriginal.setDocAction("RC");
                boolean ok = this.m_mPaymentOriginal.processIt("RC");
                this.m_mPaymentOriginal.save();
                if (ok) {
                    log.info("Payment Canecelled - " + this.m_mPaymentOriginal);
                } else {
                    log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
                }
                this.m_mPayment.resetNew();
            } else if ("KTSD".indexOf(this.m_PaymentRule) != -1 && "KTSD".indexOf(newPaymentRule) == -1) {
                log.fine("Old Payment(2) - " + this.m_mPaymentOriginal);
                if (this.m_mPaymentOriginal != null) {
                    this.m_mPaymentOriginal.setDocAction("RC");
                    boolean ok = this.m_mPaymentOriginal.processIt("RC");
                    this.m_mPaymentOriginal.save();
                    if (ok) {
                        log.fine("PaymentCancelled " + this.m_mPayment.getDocumentNo());
                        this.m_mTab.getTableModel().dataSave(true);
                        this.m_mPayment.resetNew();
                        this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
                    } else {
                        log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
                    }
                }
            }
        }
        int C_Order_ID = ctx.getContextAsInt(this.m_WindowNo, "C_Order_ID");
        int C_Invoice_ID = ctx.getContextAsInt(this.m_WindowNo, "C_Invoice_ID");
        if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
            C_Invoice_ID = WPayment.getInvoiceID(C_Order_ID);
        }
        boolean negateAmt = false;
        MInvoice invoice = null;
        if (C_Invoice_ID != 0) {
            invoice = new MInvoice(ctx, C_Invoice_ID, null);
            negateAmt = invoice.isCreditMemo();
        }
        MOrder order = null;
        if (invoice == null && C_Order_ID != 0) {
            order = new MOrder(ctx, C_Order_ID, null);
        }
        BigDecimal payAmount = this.m_Amount;
        if (negateAmt) {
            payAmount = this.m_Amount.negate();
        }
        log.config("C_Order_ID=" + C_Order_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", NegateAmt=" + negateAmt);
        if (newPaymentRule.equals("B")) {
            log.fine("Cash");
            if (C_Invoice_ID == 0 && order == null) {
                log.config("No Invoice!");
                log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
            } else {
                if (this.m_cashLine != null && payAmount.compareTo(this.m_cashLine.getAmount()) != 0) {
                    log.config("Changed CashBook Amount");
                    this.m_cashLine.setAmount(payAmount);
                    if (this.m_cashLine.save()) {
                        log.config("CashAmt Changed");
                    }
                }
                if (!(this.m_cashLine == null || newC_CashBook_ID == this.m_C_CashBook_ID && TimeUtil.isSameDay(this.m_cashLine.getStatementDate(), newDateAcct))) {
                    log.config("Changed CashBook/Date: " + this.m_C_CashBook_ID + "->" + newC_CashBook_ID);
                    MCashLine reverse = this.m_cashLine.createReversal();
                    if (!reverse.save()) {
                        log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
                    }
                    this.m_cashLine = null;
                }
                if (this.m_cashLine == null) {
                    log.config("New CashBook");
                    int C_Currency_ID = 0;
                    if (invoice != null) {
                        C_Currency_ID = invoice.getC_Currency_ID();
                    }
                    if (C_Currency_ID == 0 && order != null) {
                        C_Currency_ID = order.getC_Currency_ID();
                    }
                    MCash cash = null;
                    cash = newC_CashBook_ID != 0 ? MCash.get(ctx, newC_CashBook_ID, newDateAcct, null) : MCash.get(ctx, this.m_AD_Org_ID, newDateAcct, C_Currency_ID, null);
                    if (cash == null || cash.get_ID() == 0) {
                        log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
                    } else {
                        MCashLine cl = new MCashLine(cash);
                        if (invoice != null) {
                            cl.setInvoice(invoice);
                        }
                        if (order != null) {
                            cl.setOrder(order, null);
                            this.m_needSave = true;
                        }
                        if (cl.save()) {
                            log.config("CashCreated");
                        } else {
                            log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "CashNotCancelled");
                        }
                    }
                }
            }
        }
        if ("KTSD".indexOf(newPaymentRule) != -1) {
            log.fine("Payment - " + newPaymentRule);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
            if (newPaymentRule.equals("K")) {
                this.m_mPayment.setCreditCard("S", newCCType, this.kNumberField, "", this.kExpField);
                this.m_mPayment.setPaymentProcessor();
            } else if (newPaymentRule.equals("T") || newPaymentRule.equals("D")) {
                this.m_mPayment.setBankACH(newC_BankAccount_ID, this.m_isSOTrx, newPaymentRule, this.tRoutingField, this.tNumberField);
            } else if (newPaymentRule.equals("S")) {
                this.m_mPayment.setBankCheck(newC_BankAccount_ID, this.m_isSOTrx, this.sRoutingField, this.sNumberField, this.sCheckField);
            }
            this.m_mPayment.setC_BPartner_ID(this.m_C_BPartner_ID);
            this.m_mPayment.setC_Invoice_ID(C_Invoice_ID);
            if (order != null) {
                this.m_mPayment.setC_Order_ID(C_Order_ID);
                this.m_needSave = true;
            }
            this.m_mPayment.setDateTrx(this.m_DateAcct);
            this.m_mPayment.setDateAcct(this.m_DateAcct);
            this.m_mPayment.save();
            if ("DR".equals(this.m_mPayment.getDocStatus())) {
                boolean ok = this.m_mPayment.processIt("CO");
                this.m_mPayment.save();
                if (ok) {
                    log.log(Level.INFO, Msg.translate(ctx, "PaymentCreated"));
                } else {
                    log.log(Level.SEVERE, Msg.translate(ctx, "PaymentError") + "PaymentNotCreated");
                }
            } else {
                log.fine("NotDraft " + this.m_mPayment);
            }
        }
        log.config("Saving changes");
        if (!newPaymentRule.equals(this.m_PaymentRule)) {
            this.m_mTab.setValue("PaymentRule", (Object)newPaymentRule);
        }
        if (!newDateAcct.equals(this.m_DateAcct)) {
            this.m_mTab.setValue("DateAcct", (Object)newDateAcct);
        }
        if (newC_PaymentTerm_ID != this.m_C_PaymentTerm_ID) {
            this.m_mTab.setValue("C_PaymentTerm_ID", (Object)new Integer(newC_PaymentTerm_ID));
        }
        if (this.m_mPayment.getC_Payment_ID() != this.m_C_Payment_ID) {
            if (this.m_mPayment.getC_Payment_ID() == 0) {
                this.m_mTab.setValue("C_Payment_ID", null);
            } else {
                this.m_mTab.setValue("C_Payment_ID", (Object)new Integer(this.m_mPayment.getC_Payment_ID()));
            }
        }
        if (newC_CashLine_ID != this.m_C_CashLine_ID) {
            if (newC_CashLine_ID == 0) {
                this.m_mTab.setValue("C_CashLine_ID", null);
            } else {
                this.m_mTab.setValue("C_CashLine_ID", (Object)new Integer(newC_CashLine_ID));
            }
        }
        return true;
    }

    private static int getInvoiceID(int C_Order_ID) {
        int retValue = 0;
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? ORDER BY C_Invoice_ID DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_Order_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return retValue;
    }

    public boolean needSave() {
        return this.m_needSave;
    }

    private Map readReference(int AD_Reference_ID, Ctx ctx) {
        HashMap<String, String> values = new HashMap<String, String>();
        String SQL = Env.isBaseLanguage(ctx, "AD_Ref_List") ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=?" : "SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(ctx) + "'" + " AND l.AD_Reference_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_Reference_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = rs.getString(1);
                String name = rs.getString(2);
                values.put(value, name);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
        return values;
    }
}

