/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import java.util.Vector;
import org.compiere.model.MUserQuery;
import org.compiere.model.MUserQueryLine;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedRow
extends Vector<ValueNamePair> {
    public static Vector<AdvancedRow> load(MUserQuery query) {
        Vector<AdvancedRow> retValue = new Vector<AdvancedRow>();
        MUserQueryLine[] lines = query.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MUserQueryLine line = lines[i];
            ValueNamePair column = new ValueNamePair(line.getKeyValue(), line.getKeyName());
            ValueNamePair operator = line.getOperatorPair();
            ValueNamePair value = new ValueNamePair(line.getValue1Value(), line.getValue1Name());
            ValueNamePair value2 = null;
            if (line.getValue2Value() != null) {
                value2 = new ValueNamePair(line.getValue2Value(), line.getValue2Name());
            }
            AdvancedRow row = new AdvancedRow(column, operator, value, value2);
            retValue.add(row);
        }
        return retValue;
    }

    public static boolean store(MUserQuery query, Vector<AdvancedRow> rows) {
        query.deleteLines();
        if (rows == null) {
            return true;
        }
        for (int i = 0; i < rows.size(); ++i) {
            AdvancedRow row = rows.get(i);
            MUserQueryLine line = new MUserQueryLine(query, (i + 1) * 10, row.getColumn(), row.getOperator().getValue(), row.getValue(), row.getValue2());
            line.save();
        }
        return true;
    }

    public AdvancedRow() {
        this(null, null, null, null);
    }

    public AdvancedRow(ValueNamePair column, ValueNamePair operator, ValueNamePair value, ValueNamePair value2) {
        super(4);
        this.setColumn(column);
        this.setOperator(operator);
        this.setValue(value);
        this.setValue2(value2);
    }

    public ValueNamePair getColumn() {
        if (this.size() > 0) {
            return (ValueNamePair)this.get(0);
        }
        return null;
    }

    public void setColumn(ValueNamePair column) {
        if (this.size() < 1) {
            this.add(column);
        } else {
            this.set(0, column);
        }
    }

    public ValueNamePair getOperator() {
        if (this.size() > 1) {
            return (ValueNamePair)this.get(1);
        }
        return null;
    }

    public void setOperator(ValueNamePair operator) {
        if (this.size() < 2) {
            this.add(operator);
        } else {
            this.set(1, operator);
        }
    }

    public ValueNamePair getValue() {
        if (this.size() > 2) {
            return (ValueNamePair)this.get(2);
        }
        return null;
    }

    public void setValue(ValueNamePair value) {
        if (this.size() < 3) {
            this.add(value);
        } else {
            this.set(2, value);
        }
    }

    public ValueNamePair getValue2() {
        if (this.size() > 3) {
            return (ValueNamePair)this.get(3);
        }
        return null;
    }

    public void setValue2(ValueNamePair value2) {
        if (this.size() < 4) {
            this.add(value2);
        } else {
            this.set(3, value2);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        ValueNamePair pp = this.getColumn();
        if (pp != null) {
            sb.append(pp.getName());
        }
        if ((pp = this.getOperator()) != null) {
            sb.append(pp.getName());
        }
        if ((pp = this.getValue()) != null) {
            sb.append(pp.getName());
        }
        if ((pp = this.getValue2()) != null) {
            sb.append(" - ").append(pp.getName());
        }
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer();
        ValueNamePair pp = this.getColumn();
        if (pp != null) {
            sb.append(pp.toStringX());
        }
        if ((pp = this.getOperator()) != null) {
            sb.append(" - ").append(pp.toStringX());
        }
        if ((pp = this.getValue()) != null) {
            sb.append(" - ").append(pp.toStringX());
        }
        if ((pp = this.getValue2()) != null) {
            sb.append(" - ").append(pp.toStringX());
        }
        return sb.toString();
    }
}

