/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.common.PopupBaseForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.td;
import org.compiere.framework.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AmpiereUtil {
    private static CLogger log = CLogger.getCLogger(AmpiereUtil.class);
    public static final int MAX_RECORD_NUM = 1000;
    public static final String AD_Language_en_US = "en_US";
    public static final String AD_Language_en_GB = "en_GB";
    public static final String AD_Language_ca_ES = "ca_ES";
    public static final String AD_Language_hr_HR = "hr_HR";
    public static final String AD_Language_de_DE = "de_DE";
    public static final String AD_Language_it_IT = "it_IT";
    public static final String AD_Language_es_ES = "es_ES";
    public static final String AD_Language_es_MX = "es_MX";
    public static final String AD_Language_fr_FR = "fr_FR";
    public static final String AD_Language_bg_BG = "bg_BG";
    public static final String AD_Language_th_TH = "th_TH";
    public static final String AD_Language_pl_PL = "pl_PL";
    public static final String AD_Language_zh_TW = "zh_TW";
    public static final String AD_Language_nl_NL = "nl_NL";
    public static final String AD_Language_no_NO = "no_NO";
    public static final String AD_Language_pt_BR = "pt_BR";
    public static final String AD_Language_ru_RU = "ru_RU";
    public static final String AD_Language_sl_SI = "sl_SI";
    public static final String AD_Language_sv_SE = "sv_SE";
    public static final String AD_Language_vi_VN = "vi_VN";
    public static final String AD_Language_zh_CN = "zh_CN";
    public static final String AD_Language_da_DK = "da_DK";
    public static final String AD_Language_ml_ML = "ml_ML";
    public static final String AD_Language_fa_IR = "fa_IR";
    public static final String AD_Language_fi_FI = "fi_FI";
    public static final String AD_Language_ro_RO = "ro_RO";
    public static final String AD_Language_ja_JP = "ja_JP";
    public static final String AD_Language_in_ID = "in_ID";
    public static final String AD_Language_ar_TN = "ar_TN";

    public static String maskHTML(String content) {
        String s = Util.maskHTML(content);
        if (WebEnv.NBSP.equalsIgnoreCase(s) || "&nbsp".equalsIgnoreCase(s)) {
            return "";
        }
        return s;
    }

    public static String maskHtmlCR(String content) {
        String s = AmpiereUtil.maskHTML(content);
        s = s.replaceAll("\n", WebEnv.NBSP);
        return s;
    }

    public static int getFixedColumnID(String columnName) {
        if (columnName == null) {
            return 0;
        }
        int AD_Column_ID = 0;
        if (columnName.indexOf("BPartner") >= 0) {
            AD_Column_ID = 3499;
        } else if (columnName.indexOf("Product") >= 0) {
            AD_Column_ID = 3840;
        } else if (columnName.indexOf("Invoice") >= 0) {
            AD_Column_ID = 5355;
        } else if (columnName.indexOf("Asset") >= 0) {
            AD_Column_ID = 271;
        } else if (columnName.indexOf("Order") >= 0) {
            AD_Column_ID = 12925;
        } else if (columnName.indexOf("InOut") < 0) {
            if (columnName.indexOf("Payment") >= 0) {
                AD_Column_ID = 4884;
            } else if (columnName.indexOf("CashLine") < 0) {
                if (columnName.indexOf("ResourceAssigment") >= 0) {
                    AD_Column_ID = 6851;
                } else if (columnName.indexOf("Currency") >= 0) {
                    AD_Column_ID = 3505;
                } else if (columnName.indexOf("User") >= 0) {
                    AD_Column_ID = 10510;
                }
            }
        }
        return AD_Column_ID;
    }

    public static String getFixedColumnName(String columnName) {
        String id = "General";
        if (columnName == null) {
            return id;
        }
        if (columnName.indexOf("BPartner") >= 0) {
            id = "BPartner";
        } else if (columnName.indexOf("Product") >= 0) {
            id = "Product";
        } else if (columnName.indexOf("Invoice") >= 0) {
            id = "Invoice";
        } else if (columnName.indexOf("Asset") >= 0) {
            id = "Asset";
        } else if (columnName.indexOf("Order") >= 0) {
            id = "Order";
        } else if (columnName.indexOf("InOut") >= 0) {
            id = "InOut";
        } else if (columnName.indexOf("Payment") >= 0) {
            id = "Payment";
        } else if (columnName.indexOf("CashLine") >= 0) {
            id = "CashLine";
        } else if (columnName.indexOf("ResourceAssignment") >= 0) {
            id = "Assignment";
        }
        return id;
    }

    public static String getMonths(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        return AmpiereUtil.generateJavascriptArray(formatDate.getDateFormatSymbols().getMonths());
    }

    public static String getShortMonths(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        return AmpiereUtil.generateJavascriptArray(formatDate.getDateFormatSymbols().getShortMonths());
    }

    public static String getWeeks(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        String[] wk = formatDate.getDateFormatSymbols().getWeekdays();
        String[] weekss = new String[7];
        for (int i = 1; i < wk.length; ++i) {
            weekss[i - 1] = wk[i];
        }
        return AmpiereUtil.generateJavascriptArray(weekss);
    }

    public static String getShortWeeks(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        String[] swk = formatDate.getDateFormatSymbols().getShortWeekdays();
        String[] shortWeekss = new String[7];
        for (int i = 1; i < swk.length; ++i) {
            shortWeekss[i - 1] = swk[i];
        }
        return AmpiereUtil.generateJavascriptArray(shortWeekss);
    }

    public static String generateJavascriptArray(String[] p2) {
        String s = "new Array(";
        for (int i = 0; i < p2.length; ++i) {
            if (p2[i] == null || p2[i].length() <= 0) continue;
            s = s + "\"" + p2[i] + "\",";
        }
        s = s.substring(0, s.length() - 1);
        s = s + ")";
        return s;
    }

    public static head addDatePicker(head hd, WebSessionCtx wsc) {
        AmpiereUtil.addDateTimePicker(hd, wsc);
        return hd;
    }

    public static head addDateTimePicker(head hd, WebSessionCtx wsc) {
        hd.addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/prototype.js")));
        hd.addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/effects.js")));
        hd.addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/protocalendar.js")));
        hd.addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/lang_ja.js")));
        hd.addElement((org.apache.ecs.Element)new link(WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/stylesheets/simple.css"), "stylesheet", "text/css"));
        return hd;
    }

    public static void addDateTimePickerScript(org.apache.ecs.Element element, String inputBoxId, String buttonId, Language lang) {
        StringBuffer sb = new StringBuffer();
        String datetimePattern = AmpiereUtil.getCalendarLocaleDatetimePattern(lang.getAD_Language());
        sb.append("InputCalendar.createOnLoaded('").append(inputBoxId + "',").append("{format: '" + datetimePattern + "',").append("enableHourMinute: true,").append("lang: '" + AmpiereUtil.getCalendarLocale(lang.getAD_Language()) + "',").append("triggers: ['" + buttonId + "'],").append("inputReadOnly: true});");
        element.addElementToRegistry((org.apache.ecs.Element)new script(sb.toString()));
    }

    public static void addDatePickerScript(org.apache.ecs.Element element, String inputBoxId, String buttonId, Language lang) {
        StringBuffer sb = new StringBuffer();
        sb.append("InputCalendar.createOnLoaded('").append(inputBoxId + "',").append("{format: '" + lang.getDateFormat().toPattern().toLowerCase() + "',").append("enableHourMinute: false,").append("lang: '" + AmpiereUtil.getCalendarLocale(lang.getAD_Language()) + "',").append("triggers: ['" + buttonId + "'],").append("inputReadOnly: true});");
        element.addElementToRegistry((org.apache.ecs.Element)new script(sb.toString()));
    }

    public static String getLoadCalendarDateTimePickerScript(org.apache.ecs.Element element, String inputBoxId, String buttonId, Language lang) {
        StringBuffer sb = new StringBuffer();
        String datetimePattern = AmpiereUtil.getCalendarLocaleDatetimePattern(lang.getAD_Language());
        sb.append("new InputCalendar('").append(inputBoxId + "',").append("{format: '" + datetimePattern + "',").append("enableHourMinute: true,").append("lang: '" + AmpiereUtil.getCalendarLocale(lang.getAD_Language()) + "',").append("triggers: ['" + buttonId + "'],").append("inputReadOnly: true});");
        return sb.toString();
    }

    public static String getLoadCalendarDatePickerScript(org.apache.ecs.Element element, String inputBoxId, String buttonId, Language lang) {
        StringBuffer sb = new StringBuffer();
        sb.append("new InputCalendar('").append(inputBoxId + "',").append("{format: '" + lang.getDateFormat().toPattern().toLowerCase() + "',").append("enableHourMinute: false,").append("lang: '" + AmpiereUtil.getCalendarLocale(lang.getAD_Language()) + "',").append("triggers: ['" + buttonId + "'],").append("inputReadOnly: true});");
        return sb.toString();
    }

    public static td createButtons(Ctx ctx, boolean hasSubmit) {
        td tdButton = (td)new td().setClass("button-box");
        if (hasSubmit) {
            tdButton.addElement((org.apache.ecs.Element)AmpiereUtil.createImageButton(ctx, "Ok", ""));
            tdButton.addElement((org.apache.ecs.Element)new span("OK"));
        }
        tdButton.addElement((org.apache.ecs.Element)AmpiereUtil.createImageButton(ctx, "Cancel", "window.opener.top.WWindow.document.WForm.PCommand.value='Refresh';window.opener.top.WWindow.document.WForm.submit();window.close();"));
        tdButton.addElement((org.apache.ecs.Element)new span("\u30ad\u30e3\u30f3\u30bb\u30eb"));
        return tdButton;
    }

    public static input createImageButton(Ctx ctx, String name, String script2) {
        input imgButton = new input("image", name, name);
        imgButton.setID("Popup" + name);
        imgButton.setOnClick(script2);
        imgButton.setSrc(WebEnv.getImageDirectory(name + "32.png"));
        imgButton.setAlt(Msg.translate(ctx, name));
        return imgButton;
    }

    public static int setLargeRecordMsg(Ctx ctx, PopupBaseForm form, int rowNum) {
        if (rowNum > 1000) {
            MessageFormat mf = null;
            try {
                mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(ctx), "LargeRecords"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "LargeRecords=" + Msg.getMsg(Env.getAD_Language(ctx), "LargeRecords"), e);
            }
            Object[] arguments = new Object[]{new Integer(rowNum), new Integer(1000)};
            form.setLargeRecords(mf.format(arguments));
            return 1000;
        }
        form.setLargeRecords("");
        return rowNum;
    }

    public static String getDirectAccessSQL(Ctx ctx, Lookup lookup, String columnName, String text) {
        int AD_Reference_ID;
        StringBuffer sql = new StringBuffer();
        String tableName = columnName.substring(0, columnName.length() - 3);
        String keyColumnName = columnName;
        if (columnName.equals("M_Product_ID")) {
            ctx.setContext(1113, "M_Product_ID", "0");
            ctx.setContext(1113, "M_AttributeSetInstance_ID", "0");
            sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(" OR UPC LIKE ").append(DB.TO_STRING(text)).append(")");
        } else if (columnName.equals("C_BPartner_ID")) {
            sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING(text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING(text)).append(")");
        } else if (columnName.equals("C_Order_ID")) {
            sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("C_Invoice_ID")) {
            sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("M_InOut_ID")) {
            sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("C_Payment_ID")) {
            sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("GL_JournalBatch_ID")) {
            sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING(text));
        } else if (columnName.equals("SalesRep_ID")) {
            sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING(text));
            tableName = "AD_User";
            keyColumnName = "AD_User_ID";
        }
        if (sql.length() > 0) {
            String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
            if (wc != null && wc.length() > 0) {
                sql.append(" AND ").append(wc);
            }
            sql.append(" AND IsActive='Y'");
            log.finest(columnName + " (predefined) " + sql.toString());
            return MRole.getDefault(ctx, false).addAccessSQL(sql.toString(), tableName, false, false);
        }
        if (lookup != null && lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)lookup).getAD_Reference_Value_ID()) != 0) {
            String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
            String displayColumnName = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(query, null);
                pstmt.setInt(1, AD_Reference_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyColumnName = rs.getString(1);
                    displayColumnName = rs.getString(2);
                    tableName = rs.getString(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, query, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (displayColumnName != null) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(keyColumnName).append(" FROM ").append(tableName).append(" WHERE UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING(text)).append(" AND IsActive='Y'");
                String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                log.finest(columnName + " (Table) " + sql.toString());
                return MRole.getDefault(ctx, false).addAccessSQL(sql.toString(), tableName, false, false);
            }
        }
        String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
        keyColumnName = columnName;
        sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(query, null);
            pstmt.setString(1, keyColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sql.length() != 0) {
                    sql.append(" OR ");
                }
                tableName = rs.getString(1);
                sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING(text));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, query, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (sql.length() == 0) {
            log.log(Level.SEVERE, columnName + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(tableName).append(" WHERE ").append(sql).append(" AND IsActive='Y'");
        String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        log.finest(columnName + " (TableDir) " + sql.toString());
        return MRole.getDefault(ctx, false).addAccessSQL(retValue.toString(), tableName, false, false);
    }

    public static String getWhereClause(Ctx ctx, Lookup lookup, String columnName) {
        String validation;
        String whereClause = "";
        if (lookup == null) {
            return "";
        }
        if (lookup.getZoomQuery() != null) {
            whereClause = lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = whereClause + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext(ctx, lookup.getWindowNo(), whereClause, false);
            if (validated.length() == 0) {
                log.severe(columnName + " - Cannot Parse=" + whereClause);
            } else {
                log.fine(columnName + " - Parsed: " + validated);
                return validated;
            }
        }
        return whereClause;
    }

    public static int getOnly_Warehouse_ID(Ctx ctx, int windowNo) {
        String only_Warehouse = ctx.getContext(windowNo, "M_Warehouse_ID", true);
        int only_Warehouse_ID = 0;
        try {
            if (only_Warehouse != null && only_Warehouse.length() > 0) {
                only_Warehouse_ID = Integer.parseInt(only_Warehouse);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return only_Warehouse_ID;
    }

    public static String getBPartnerName(String Value) {
        if (Value == null || Value.length() == 0) {
            return null;
        }
        String retValue = null;
        String sql = "SELECT NAME FROM C_BPartner WHERE C_BPARTNER_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, Value);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getString("NAME");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static String sanitizing(String str) {
        if (!StringUtils.isEmpty(str)) {
            if (str.indexOf("&amp;") >= 0 || str.indexOf("&lt;") >= 0 || str.indexOf("&gt;") >= 0 || str.indexOf("&quot;") >= 0 || str.indexOf("&#39;") >= 0) {
                return str;
            }
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = str.replaceAll("\"", "&quot;");
            str = str.replaceAll("'", "&#39;");
        }
        return str;
    }

    public static String getCalendarLocale(String lang) {
        String Calendar_Locale_en_US = "en";
        String Calendar_Locale_en_GB = AD_Language_en_GB;
        String Calendar_Locale_de_DE = "de";
        String Calendar_Locale_it_IT = "it";
        String Calendar_Locale_es_ES = "es";
        String Calendar_Locale_fr_FR = "fr";
        String Calendar_Locale_pl_PL = "pl";
        String Calendar_Locale_zh_TW = "zh-tw";
        String Calendar_Locale_pt_BR = "pt-BR";
        String Calendar_Locale_ru_RU = "ru";
        String Calendar_Locale_zh_CN = "zh-cn";
        String Calendar_Locale_ro_RO = "ro";
        String Calendar_Locale_ja_JP = "ja";
        String calendarLocale = Calendar_Locale_en_US;
        if (AD_Language_en_GB.equals(lang)) {
            calendarLocale = Calendar_Locale_en_GB;
        } else if (AD_Language_de_DE.equals(lang)) {
            calendarLocale = Calendar_Locale_de_DE;
        } else if (AD_Language_it_IT.equals(lang)) {
            calendarLocale = Calendar_Locale_it_IT;
        } else if (AD_Language_es_ES.equals(lang)) {
            calendarLocale = Calendar_Locale_es_ES;
        } else if (AD_Language_fr_FR.equals(lang)) {
            calendarLocale = Calendar_Locale_fr_FR;
        } else if (AD_Language_pl_PL.equals(lang)) {
            calendarLocale = Calendar_Locale_pl_PL;
        } else if (AD_Language_zh_TW.equals(lang)) {
            calendarLocale = Calendar_Locale_zh_TW;
        } else if (AD_Language_pt_BR.equals(lang)) {
            calendarLocale = Calendar_Locale_pt_BR;
        } else if (AD_Language_ru_RU.equals(lang)) {
            calendarLocale = Calendar_Locale_ru_RU;
        } else if (AD_Language_zh_CN.equals(lang)) {
            calendarLocale = Calendar_Locale_zh_CN;
        } else if (AD_Language_ro_RO.equals(lang)) {
            calendarLocale = Calendar_Locale_ro_RO;
        } else if (AD_Language_ja_JP.equals(lang)) {
            calendarLocale = Calendar_Locale_ja_JP;
        }
        return calendarLocale;
    }

    public static String getCalendarLocaleDatetimePattern(String lang) {
        String Calendar_Locale_en_US = "en";
        String Calendar_Locale_Pattern_en_GB = "dd-MMM-yyyy HH:mm:ss JST";
        String Calendar_Locale_Pattern_zh_TW = "yyyy/M/d ahh'\u6642'mm'\u5206'ss'\u79d2'";
        String Calendar_Locale_Pattern_zh_CN = "yyyy-M-d ahh'\u65f6'mm'\u5206'ss'\u79d2'";
        String Calendar_Locale_Pattern_ja_JP = "yyyy/mm/dd HH:MM:ss JST";
        String localePattern = "mmm d, yyyy h:mm:ss TT JST";
        if (AD_Language_en_GB.equals(lang)) {
            localePattern = Calendar_Locale_Pattern_en_GB;
        } else if (AD_Language_zh_TW.equals(lang)) {
            localePattern = Calendar_Locale_Pattern_zh_TW;
        } else if (AD_Language_zh_CN.equals(lang)) {
            localePattern = Calendar_Locale_Pattern_zh_CN;
        } else if (AD_Language_ja_JP.equals(lang)) {
            localePattern = Calendar_Locale_Pattern_ja_JP;
        }
        return localePattern;
    }

    public static boolean isWorkflowProcess(Ctx ctx) {
        boolean s_workflow = Boolean.FALSE;
        int AD_Table_ID = 645;
        if (MRole.getDefault(ctx, false).isTableAccess(AD_Table_ID, true)) {
            s_workflow = Boolean.TRUE;
        } else {
            AD_Table_ID = 644;
            if (MRole.getDefault(ctx, false).isTableAccess(AD_Table_ID, true)) {
                s_workflow = Boolean.TRUE;
            } else {
                log.config(String.valueOf(s_workflow));
            }
        }
        if (s_workflow) {
            int s_workflow_Window_ID = DB.getSQLValue(null, "SELECT AD_Window_ID FROM AD_Table WHERE AD_Table_ID=?", AD_Table_ID);
            if (s_workflow_Window_ID == 0) {
                s_workflow_Window_ID = 297;
            }
            log.config(s_workflow + ", Window=" + s_workflow_Window_ID);
        }
        return s_workflow;
    }

    public static void addProcessMsg(HttpServletRequest request, WebDoc doc) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        div processMsgDiv = new div();
        processMsgDiv.setID("progressMsg");
        processMsgDiv.setStyle("padding-top:1px;display:none;");
        img imgLoading = new img();
        imgLoading.setAlt("Wait a moment...");
        imgLoading.setAlign("right");
        imgLoading.setSrc(WebEnv.getImageDirectory("Loading-0.gif"));
        processMsgDiv.addElement((org.apache.ecs.Element)imgLoading);
        doc.getBody().addElement((org.apache.ecs.Element)processMsgDiv);
    }

    public static Document addScriptToDocument(Document document, String script2) {
        Element elementScript = document.createElement("script");
        document.getFirstChild().appendChild(elementScript);
        Element elm = document.createElement("item");
        elm.appendChild(document.createTextNode(script2));
        elementScript.appendChild(elm);
        return document;
    }

    public static String getAlertScript(String script2) {
        return "alert('" + script2 + "');";
    }

    public static Document getCloseWindowScript(HttpServletRequest request) {
        Document document = AmpiereUtil.CreateNewDocument(request);
        document = AmpiereUtil.addScriptToDocument(document, "window.close();");
        return document;
    }

    public static Document CreateNewDocument(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }
}

