/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.util.BarGraphColumn;
import com.ampiere.util.BarGraphLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.Query;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasure;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.model.MStatus;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class BarGraph
extends CPanel
implements ActionListener {
    private static final long serialVersionUID = -1449348372662325427L;
    private MGoal m_goal = null;
    private Dimension m_size = null;
    private Point m_point0_0 = null;
    private BarGraphLayout m_layout = new BarGraphLayout(this);
    private static CLogger log = CLogger.getCLogger(BarGraph.class);
    private String m_X_AxisLabel = "X Axis";
    private String m_Y_AxisLabel = "Y Axis";
    private String m_Y_TargetLabel = null;

    public BarGraph() {
        this.setLayout(this.m_layout);
        this.m_size = new Dimension(500, 300);
        this.setPreferredSize(this.m_size);
        this.setMinimumSize(this.m_size);
        this.setMaximumSize(this.m_size);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        int yAxis_X = fontHeight + 10;
        int xAxis_Y = this.m_size.height - fontHeight - 10;
        this.m_point0_0 = new Point(yAxis_X, xAxis_Y);
    }

    public BarGraph(MGoal goal) {
        this();
        this.m_goal = goal;
        this.m_Y_AxisLabel = goal.getName();
        this.m_X_AxisLabel = goal.getXAxisText();
        this.loadData();
    }

    private void loadData() {
        BarGraphColumn bgc;
        BigDecimal data;
        ResultSet rs;
        CPreparedStatement pstmt;
        ArrayList<BarGraphColumn> list = new ArrayList<BarGraphColumn>();
        MMeasure measure = this.m_goal.getMeasure();
        if (measure == null) {
            log.warning("No Measure for " + this.m_goal);
            return;
        }
        if ("C".equals(measure.getMeasureType())) {
            MMeasureCalc mc = MMeasureCalc.get(this.m_goal.getCtx(), measure.getPA_MeasureCalc_ID());
            String sql = mc.getSqlBarChart(this.m_goal.getRestrictions(false), this.m_goal.getMeasureDisplay(), null, MRole.getDefault(this.m_goal.getCtx(), false));
            pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    data = rs.getBigDecimal(1);
                    Timestamp date = rs.getTimestamp(2);
                    BarGraphColumn bgc2 = new BarGraphColumn(mc, data);
                    bgc2.setLabel(date, this.m_goal.getMeasureDisplay());
                    list.add(bgc2);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        } else if ("A".equals(measure.getMeasureType())) {
            if ("S".equals(measure.getMeasureDataType())) {
                MAchievement[] achievements = MAchievement.get(measure);
                for (int i = 0; i < achievements.length; ++i) {
                    MAchievement achievement = achievements[i];
                    BarGraphColumn bgc3 = new BarGraphColumn(achievement);
                    list.add(bgc3);
                }
            } else {
                String MeasureDisplay = this.m_goal.getMeasureDisplay();
                String trunc = "D";
                if ("1".equals(MeasureDisplay)) {
                    trunc = "Y";
                } else if ("3".equals(MeasureDisplay)) {
                    trunc = "Q";
                } else if ("5".equals(MeasureDisplay)) {
                    trunc = "MM";
                } else if ("7".equals(MeasureDisplay)) {
                    trunc = "W";
                }
                trunc = "TRUNC(DateDoc,'" + trunc + "')";
                StringBuffer sql = new StringBuffer("SELECT SUM(ManualActual), ").append(trunc).append(" FROM PA_Achievement WHERE PA_Measure_ID=? AND IsAchieved='Y' ").append("GROUP BY ").append(trunc).append(" ORDER BY ").append(trunc);
                CPreparedStatement pstmt2 = null;
                try {
                    pstmt2 = DB.prepareStatement(sql.toString(), null);
                    pstmt2.setInt(1, measure.getPA_Measure_ID());
                    ResultSet rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        BigDecimal data2 = rs2.getBigDecimal(1);
                        Timestamp date = rs2.getTimestamp(2);
                        bgc = new BarGraphColumn(this.m_goal, data2);
                        bgc.setLabel(date, this.m_goal.getMeasureDisplay());
                        list.add(bgc);
                    }
                    rs2.close();
                    pstmt2.close();
                    pstmt2 = null;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                }
                try {
                    if (pstmt2 != null) {
                        pstmt2.close();
                    }
                    pstmt2 = null;
                }
                catch (Exception e) {
                    pstmt2 = null;
                }
            }
        } else if ("Q".equals(measure.getMeasureType())) {
            MRequestType rt = MRequestType.get(this.m_goal.getCtx(), measure.getR_RequestType_ID());
            String sql = rt.getSqlBarChart(this.m_goal.getRestrictions(false), this.m_goal.getMeasureDisplay(), measure.getMeasureDataType(), null, MRole.getDefault(this.m_goal.getCtx(), false));
            pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    data = rs.getBigDecimal(1);
                    int R_Status_ID = rs.getInt(3);
                    BarGraphColumn bgc4 = new BarGraphColumn(rt, data, R_Status_ID);
                    if (R_Status_ID == 0) {
                        Timestamp date = rs.getTimestamp(2);
                        bgc4.setLabel(date, this.m_goal.getMeasureDisplay());
                    } else {
                        MStatus status = MStatus.get(this.m_goal.getCtx(), R_Status_ID);
                        bgc4.setLabel(status.getName());
                    }
                    list.add(bgc4);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        } else if ("P".equals(measure.getMeasureType())) {
            MProjectType pt = MProjectType.get(this.m_goal.getCtx(), measure.getC_ProjectType_ID());
            String sql = pt.getSqlBarChart(this.m_goal.getRestrictions(false), this.m_goal.getMeasureDisplay(), measure.getMeasureDataType(), null, MRole.getDefault(this.m_goal.getCtx(), false));
            pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    data = rs.getBigDecimal(1);
                    Timestamp date = rs.getTimestamp(2);
                    int id = rs.getInt(3);
                    bgc = new BarGraphColumn(pt, data, id);
                    bgc.setLabel(date, this.m_goal.getMeasureDisplay());
                    list.add(bgc);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        int startValue = 0;
        if (list.size() > 20) {
            startValue = list.size() - 20;
        }
        for (int i = startValue; i < list.size(); ++i) {
            this.add((BarGraphColumn)list.get(i));
        }
    }

    public Point getPoint0_0() {
        return this.m_point0_0;
    }

    public String getX_AxisLabel() {
        return this.m_X_AxisLabel;
    }

    public void setX_AxisLabel(String axisLabel) {
        this.m_X_AxisLabel = axisLabel;
    }

    public String getY_AxisLabel() {
        return this.m_Y_AxisLabel;
    }

    public void setY_AxisLabel(String axisLabel) {
        this.m_Y_AxisLabel = axisLabel;
    }

    public String getY_TargetLabel() {
        return this.m_Y_TargetLabel;
    }

    public void setY_TargetLabel(String targetLabel, double target) {
        this.m_Y_TargetLabel = targetLabel;
    }

    public void add(BarGraphColumn column) {
        super.add((Component)column, "column");
        column.addActionListener(this);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Dimension size = this.getPreferredSize();
        Font font = this.getFont();
        FontMetrics fm = g2D.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int yAxis_X = this.m_point0_0.x;
        int xAxis_Y = this.m_point0_0.y;
        g2D.setColor(Color.black);
        g2D.drawLine(yAxis_X, xAxis_Y, size.width - 5, xAxis_Y);
        g2D.setFont(font);
        g2D.drawString(this.m_X_AxisLabel, yAxis_X, xAxis_Y + fontHeight);
        g2D.drawLine(yAxis_X, 5, yAxis_X, xAxis_Y);
        AffineTransform transform = AffineTransform.getRotateInstance(4.71238898038469);
        font = font.deriveFont(transform);
        g2D.setFont(font);
        g2D.drawString(this.m_Y_AxisLabel, yAxis_X - fontHeight + 10, xAxis_Y);
        super.paintComponent(g2D);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof BarGraphColumn) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            BarGraphColumn bgc = (BarGraphColumn)e.getSource();
            log.info(bgc.getName());
            Query query = null;
            if (bgc.getAchievement() != null) {
                MAchievement a2 = bgc.getAchievement();
                query = Query.getEqualQuery("PA_Measure_ID", a2.getPA_Measure_ID());
            } else if (bgc.getGoal() != null) {
                MGoal goal = bgc.getGoal();
                query = Query.getEqualQuery("PA_Measure_ID", goal.getPA_Measure_ID());
            } else if (bgc.getMeasureCalc() != null) {
                MMeasureCalc mc = bgc.getMeasureCalc();
                query = mc.getQuery(this.m_goal.getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), MRole.getDefault(this.m_goal.getCtx(), false));
            } else if (bgc.getProjectType() != null) {
                MProjectType pt = bgc.getProjectType();
                query = pt.getQuery(this.m_goal.getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault(this.m_goal.getCtx(), false));
            } else if (bgc.getRequestType() != null) {
                MRequestType rt = bgc.getRequestType();
                query = rt.getQuery(this.m_goal.getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault(this.m_goal.getCtx(), false));
            }
            if (query == null) {
                log.warning("Nothing to zoom to - " + bgc);
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

