/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.JasperUtils;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.compiere.framework.Query;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Language;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WJasperReport
extends HttpServlet {
    private static final long serialVersionUID = -4091247707448190302L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WJasperReport.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web WJasperReport Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        Language oldLogin = Language.getLoginLanguage();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String sessionId = request.getSession().getId();
        WWindowStatus ws = WWindowStatus.get(request);
        Language.setLoginLanguage(wsc.language);
        int printFormatID = new Integer(request.getParameter("PrintFormat"));
        String fileName = JasperUtils.toJasperXML(printFormatID, sessionId, ws.ctx);
        if (fileName != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            int pInstanceId = WebUtil.getParameterAsInt(request, "AD_PInstance_ID");
            if (pInstanceId > 0) {
                MPInstance inst = new MPInstance(ws.ctx, pInstanceId, null);
                MPInstancePara[] params = inst.getParameters();
                for (int i2 = 0; i2 < params.length; ++i2) {
                    if (!"AD_Jasperformat_ID".equals(params[i2].getParameterName()) || params[i2].getP_Number() == null) continue;
                    params[i2].delete(true);
                }
                Query query = Query.get(ws.ctx, pInstanceId, "");
                param.put("PARAM", query.toString());
            } else {
                param.put("RECORD_ID", ws.curTab.getRecord_ID());
            }
            param.put("SUBREPORT_DIR", JasperUtils.JASPERREPORT_PATH + "/" + sessionId);
            try {
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((String)fileName);
                JasperPrint JasperPrint2 = JasperFillManager.fillReport((JasperReport)jasperReport, param, (Connection)DB.getConnectionRO());
                this.makeDownloadFile(JasperPrint2, request, response, wsc.language);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "RecordId=" + ws.curTab.getRecord_ID(), e);
            }
        }
        Language.setLoginLanguage(oldLogin);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }

    private boolean makeDownloadFile(JasperPrint jasperPrint, HttpServletRequest request, HttpServletResponse response, Language language) {
        boolean result = true;
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            if (request.getParameter("FileFormat").equals("pdf")) {
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "inline; filename=" + request.getParameter("PrintFormatName") + ".pdf");
                response.setHeader("Content-Description", "File download for PDF.");
                JRPdfExporter exporter = new JRPdfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)ouputStream);
                exporter.exportReport();
            } else if (request.getParameter("FileFormat").equals("html")) {
                response.setContentType("text/html; charset=UTF-8");
                response.setHeader("Content-Disposition", "inline; filename=" + request.getParameter("PrintFormatName") + ".html");
                response.setHeader("Content-Description", "File download for HTML.");
                JRHtmlExporter exporter = new JRHtmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)ouputStream);
                exporter.exportReport();
            } else if (request.getParameter("FileFormat").equals("xls")) {
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "inline; filename=" + request.getParameter("PrintFormatName") + ".xls");
                response.setHeader("Content-Description", "File download for HTML.");
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)ouputStream);
                exporter.exportReport();
            } else {
                result = false;
            }
            ouputStream.flush();
            ouputStream.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "ReportEngine", e);
            result = false;
        }
        return result;
    }
}

