/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.MPreference;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPreference
extends HttpServlet {
    private static final long serialVersionUID = 6617424544044122702L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "ValuePreference";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.createPreferencePage(request);
        if (doc == null) {
            doc = WebDoc.createWindow("Error");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean result;
        String actionType;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME));
        td msg = doc.addWindowCenter(false);
        p p2 = new p();
        String string = actionType = WebUtil.getParameter(request, "btn_submit") != null ? "submitAction" : "deleteAction";
        if ("submitAction".equals(actionType)) {
            result = this.save(request);
            p2.addElement(Msg.translate(ws.ctx, "ValuePreferenceInserted"));
        } else {
            result = this.delete(request);
            p2.addElement(Msg.translate(ws.ctx, "ValuePreferenceDeleted"));
        }
        msg.addElement((Element)p2);
        td botton = doc.addWindowCenter(true);
        input ok = new input("image", "btn_ok", "OK");
        ok.setSrc(WebEnv.getImageDirectory("Ok32.png"));
        ok.setID("btn_ok");
        ok.setOnClick("window.close();return false;");
        botton.addElement((Element)ok);
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createPreferencePage(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String aValue = WebUtil.getParameter(request, "aValue");
        String aDisplayValue = WebUtil.getParameter(request, "aDisplayValue");
        String columnName = WebUtil.getParameter(request, "columnName");
        GridField currentField = ws.curTab.getField(columnName);
        if (!ws.curTab.getField(columnName).isEditable(false)) {
            this.log.info("Field not editable (R/O)");
            return null;
        }
        Object Value = null;
        Object DisplayValue = null;
        int AD_Window_ID = currentField.getAD_Window_ID();
        String Attribute2 = currentField.getColumnName();
        String DisplayAttribute = currentField.getHeader();
        int displayType = currentField.getDisplayType();
        boolean AD_Reference_ID = false;
        int WindowNo = currentField.getWindowNo();
        if ("Value".equals(Attribute2) || "DocumentNo".equals(Attribute2)) {
            this.log.info("No Preference for: " + Attribute2);
            return null;
        }
        int AD_Client_ID = ws.ctx.getAD_Client_ID();
        int AD_Org_ID = ws.ctx.getContextAsInt(WindowNo, "AD_Org_ID");
        int AD_User_ID = ws.ctx.getAD_User_ID();
        WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME) + " " + DisplayAttribute);
        form myForm = new form(request.getRequestURI());
        myForm.setID("WFind");
        table myTable = new table();
        myTable.setAlign("CENTER");
        div divBody = (div)new div().setID("body");
        divBody.addElement((Element)myTable);
        tr myTr = new tr((Element)new td("&nbsp;").setColSpan(3));
        myTable.addElement((Element)myTr);
        myTr.addElement((Element)new td().addElement(Msg.translate(ws.ctx, "Attribute")));
        myTr.addElement((Element)new td().addElement(DisplayAttribute));
        input hiddenAttribute = new input("hidden", "Attribute", Attribute2);
        hiddenAttribute.setID("Attribute");
        myTr.addElement((Element)new td().addElement(Attribute2).addElement((Element)hiddenAttribute));
        myTr = new tr((Element)new td("&nbsp;").setColSpan(3));
        myTable.addElement((Element)myTr);
        myTr.addElement((Element)new td().addElement(Msg.translate(ws.ctx, "Value")));
        myTr.addElement((Element)new td().addElement(aDisplayValue));
        input hiddenAValue = new input("hidden", "aValue", aValue);
        hiddenAValue.setID("aValue");
        myTr.addElement((Element)new td().addElement(aValue).addElement((Element)hiddenAValue));
        myTr = new tr((Element)new td("&nbsp;").setColSpan(3));
        myTable.addElement((Element)myTr);
        myTr.addElement((Element)new td().addElement(Msg.getMsg(ws.ctx, "ValuePreferenceSetFor")));
        td checkboxTd = new td();
        input cbClient = new input("checkbox", "cbrClient", "");
        cbClient.setID("cbClient");
        cbClient.setChecked(true);
        cbClient.setDisabled(true);
        label clientLabel = new label("cbrClient", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_Client_ID"));
        clientLabel.setID("cbrClientL");
        cbClient.addElement((Element)clientLabel);
        checkboxTd.addElement((Element)cbClient);
        input cbOrg = new input("checkbox", "cbOrg", "0");
        cbOrg.setID("cbOrg");
        label orgLabel = new label("cbOrg", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_Org_ID"));
        orgLabel.setID("cbOrgL");
        cbOrg.addElement((Element)orgLabel);
        checkboxTd.addElement((Element)cbOrg);
        if (!"C".equals(MRole.getDefault(wsc.ctx, true).getPreferenceType())) {
            cbOrg.setDisabled(true);
            cbOrg.setChecked(true);
        }
        input cbUser = new input("checkbox", "cbUser", "1");
        cbUser.setID("cbUser");
        cbUser.setChecked(true);
        label userLabel = new label("cbUser", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_User_ID"));
        userLabel.setID("cbUserL");
        cbUser.addElement((Element)userLabel);
        checkboxTd.addElement((Element)cbUser);
        if (!"C".equals(MRole.getDefault(wsc.ctx, true).getPreferenceType()) && !"O".equals(MRole.getDefault(wsc.ctx, true).getPreferenceType())) {
            cbUser.setDisabled(true);
            cbUser.setChecked(true);
        }
        input cbWindow = new input("checkbox", "cbWindow", "1");
        cbWindow.setID("cbWindow");
        cbWindow.setChecked(true);
        label windowLabel = new label("cbWindow", null, Msg.translate(Env.getAD_Language(ws.ctx), ws.ctx.isSOTrx(), "AD_Window_ID"));
        windowLabel.setID("cbWindowL");
        cbWindow.addElement((Element)windowLabel);
        checkboxTd.addElement((Element)cbWindow);
        cbWindow.setDisabled(false);
        cbWindow.setChecked(true);
        myTr.addElement((Element)checkboxTd);
        myTr.addElement((Element)new td().addElement(""));
        myTr = new tr((Element)new td("&nbsp;").setColSpan(3));
        myTable.addElement((Element)myTr);
        input delete = new input("image", "btn_delete", "OK");
        delete.setSrc(WebEnv.getImageDirectory("Delete32.png"));
        delete.setID("btn_delete");
        myTr.addElement((Element)new td().addElement((Element)delete));
        myTr.addElement((Element)new td());
        div divButtonBox = (div)new div().setClass("button-box");
        input cancel = new input("image", "btn_cancel", "Cancel");
        cancel.setID("btn_cancel");
        cancel.setSrc(WebEnv.getImageDirectory("Cancel32.png"));
        cancel.setOnClick("window.close();return false;");
        divButtonBox.addElement((Element)cancel);
        input submit = new input("image", "btn_submit", "OK");
        submit.setSrc(WebEnv.getImageDirectory("Ok32.png"));
        submit.setID("btn_submit");
        divButtonBox.addElement((Element)submit);
        myTr.addElement((Element)new td().addElement((Element)divButtonBox));
        myForm.addElement((Element)divBody);
        doc.getBody().addElement((Element)myForm);
        return doc;
    }

    public boolean save(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String m_Value = WebUtil.getParameter(request, "aValue");
        String cbClient = WebUtil.getParameter(request, "cbClient");
        String cbOrg = WebUtil.getParameter(request, "cbOrg");
        String cbUser = WebUtil.getParameter(request, "cbUser");
        String cbWindow = WebUtil.getParameter(request, "cbWindow");
        String m_Attribute = WebUtil.getParameter(request, "Attribute");
        if (m_Value == null || m_Value.length() == 0) {
            return false;
        }
        if (m_Value.indexOf("@") != -1) {
            return false;
        }
        boolean success = false;
        int AD_Preference_ID = this.getAD_Preference_ID(request);
        MPreference pref = new MPreference(ws.ctx, AD_Preference_ID, null);
        if (AD_Preference_ID == 0) {
            int Client_ID = ws.ctx.getAD_Client_ID();
            int Org_ID = "1".equals(cbOrg) ? ws.ctx.getAD_Org_ID() : 0;
            pref.setClientOrg(Client_ID, Org_ID);
            if ("1".equals(cbWindow)) {
                pref.setAD_Window_ID(ws.mWindow.getAD_Window_ID());
            }
            if ("1".equals(cbUser)) {
                pref.setAD_User_ID(ws.ctx.getAD_User_ID());
            }
            pref.setAttribute(m_Attribute);
        }
        pref.setValue(m_Value);
        success = pref.save();
        if (success) {
            String contextKey = null;
            contextKey = "1".equals(cbWindow) ? "P" + ws.mWindow.getAD_Window_ID() + "|" + m_Attribute : "P|" + m_Attribute;
            ws.ctx.setContext(contextKey, m_Value);
        }
        return success;
    }

    private int getAD_Preference_ID(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String cbClient = WebUtil.getParameter(request, "cbClient");
        String cbOrg = WebUtil.getParameter(request, "cbOrg");
        String cbUser = WebUtil.getParameter(request, "cbUser");
        String cbWindow = WebUtil.getParameter(request, "cbWindow");
        String m_Attribute = WebUtil.getParameter(request, "Attribute");
        StringBuffer sql = new StringBuffer("SELECT AD_Preference_ID FROM AD_Preference WHERE ");
        sql.append("AD_Client_ID=").append(ws.ctx.getAD_Client_ID());
        sql.append(" AND AD_Org_ID=").append("1".equals(cbOrg) ? ws.ctx.getAD_Org_ID() : 0);
        if ("1".equals(cbUser)) {
            sql.append(" AND AD_User_ID=").append(ws.ctx.getAD_User_ID());
        } else {
            sql.append(" AND AD_User_ID IS NULL");
        }
        if ("1".equals(cbWindow)) {
            sql.append(" AND AD_Window_ID=").append(ws.mWindow.getAD_Window_ID());
        } else {
            sql.append(" AND AD_Window_ID IS NULL");
        }
        sql.append(" AND Attribute='").append(m_Attribute).append("'");
        this.log.finest(sql.toString());
        int id = DB.getSQLValue(null, sql.toString());
        if (id < 0) {
            id = 0;
        }
        return id;
    }

    public boolean delete(HttpServletRequest request) {
        MPreference pref;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String cbClient = WebUtil.getParameter(request, "cbClient");
        String cbOrg = WebUtil.getParameter(request, "cbOrg");
        String cbUser = WebUtil.getParameter(request, "cbUser");
        String cbWindow = WebUtil.getParameter(request, "cbWindow");
        String m_Attribute = WebUtil.getParameter(request, "Attribute");
        boolean success = false;
        int AD_Preference_ID = this.getAD_Preference_ID(request);
        if (AD_Preference_ID > 0 && (success = (pref = new MPreference(ws.ctx, AD_Preference_ID, null)).delete(true))) {
            String contextKey = null;
            contextKey = "1".equals(cbWindow) ? "P" + ws.mWindow.getAD_Window_ID() + "|" + m_Attribute : "P|" + m_Attribute;
            ws.ctx.setContext(contextKey, (String)null);
        }
        return success;
    }
}

