/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.FileImportForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.WebSessionCtx;

public class FileImport
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String IMP_FORMAT_LIST = "IMP_FORMAT_LIST";
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";
    private static final String ERROR_FORWARD = "error";
    private static final int ORDERLINE_WAREHOUSE_COLUMN_ID = 2223;
    private static final int FORM_ID = 110;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        wsc.ctx.setContext(0, "IsSOTrx", "Y");
        MForm form2 = this.getForm(wsc.ctx, 110);
        wsc.ctx.setContext("FormName", form2.getName());
        FileImportForm myForm = (FileImportForm)request.getAttribute(ACTION_FORM);
        if (myForm == null && (myForm = (FileImportForm)actionForm) == null) {
            myForm = new FileImportForm();
        }
        myForm.setMainWindowTitle(form2.getName() + " - " + wsc.loginInfo);
        myForm.setPageTitle(form2.getName());
        request.setAttribute(IMP_FORMAT_LIST, (Object)this.getImpFormatList());
        request.setAttribute("fileImportForm", (Object)myForm);
        return mapping.findForward(SUCCESS);
    }

    private ArrayList getImpFormatList() {
        ArrayList<NameValuePair> dataList = new ArrayList<NameValuePair>();
        String sql = "SELECT Name from AD_ImpFormat";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                NameValuePair tmp = new NameValuePair(rs.getString(1), rs.getString(1));
                dataList.add(tmp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return dataList;
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }
}

