/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.form.PayPrintForm;
import com.jware.util.StringToIntConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayPrint
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String SUCCESS = "success";
    private static final String ERROR_FORWARD = "error";
    private static final String WARNING_INFO = "warningInfo";
    private static final int FORM_ID = 106;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        String doQurey = "0";
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        MForm form2 = this.getForm(wsc.ctx, 106);
        wsc.ctx.setContext("FormName", form2.getName());
        PayPrintForm payPrintForm = null;
        if (payPrintForm == null && (payPrintForm = (PayPrintForm)actionForm) == null) {
            payPrintForm = new PayPrintForm();
        }
        payPrintForm.statInit(wsc.ctx);
        session.setAttribute("searchResultPayment", null);
        ArrayList<NamePair> paySelectList = this.getPaySelectList(request, payPrintForm);
        session.setAttribute("paySelectList", paySelectList);
        this.loadPaySelectInfo(request, payPrintForm);
        this.loadPaymentRule(request, payPrintForm);
        this.loadPaymentRuleInfo(request, payPrintForm);
        payPrintForm.setTitle(Msg.getMsg(wsc.ctx, "PayPrint"));
        session.setAttribute("payPrintForm", (Object)payPrintForm);
        if (payPrintForm.isEnabledBProcess()) {
            request.setAttribute("enabledBProcess", (Object)"1");
        }
        return mapping.findForward(SUCCESS);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private ArrayList<NamePair> getPaySelectList(HttpServletRequest request, PayPrintForm form2) {
        HttpSession session = request.getSession();
        ArrayList<NamePair> paySelectList = new ArrayList<NamePair>();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Ctx ctx = wsc.ctx;
        int AD_Client_ID = ctx.getAD_Client_ID();
        String sql = "SELECT C_PaySelection_ID, Name || ' - ' || " + DB.TO_CHAR("TotalAmt", 22, Env.getAD_Language(ctx)) + " FROM C_PaySelection " + "WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'" + "ORDER BY PayDate DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                paySelectList.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        if (paySelectList != null && paySelectList.size() > 0 && StringUtils.isEmpty(form2.getPaySelect())) {
            KeyNamePair pp = (KeyNamePair)paySelectList.get(0);
            form2.setPaySelect(String.valueOf(pp.getKey()));
        }
        return paySelectList;
    }

    public void loadPaySelectInfo(HttpServletRequest request, PayPrintForm form2) {
        this.log.info("VPayPrint.loadPaySelectInfo");
        if (StringUtils.isEmpty(form2.getPaySelect())) {
            return;
        }
        int C_PaySelection_ID = StringToIntConverter.StringToInt(form2.getPaySelect());
        form2.setM_C_BankAccount_ID(-1);
        String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance FROM C_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.C_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                form2.setM_C_BankAccount_ID(rs.getInt(1));
                form2.setBank(rs.getString(2));
                form2.setCurrency(rs.getString(3));
                form2.setBalance(rs.getBigDecimal(4).toString());
            } else {
                form2.setM_C_BankAccount_ID(-1);
                form2.setBank("");
                form2.setCurrency("");
                form2.setBalance(Env.ZERO.toString());
                this.log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + C_PaySelection_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }

    public void loadPaymentRule(HttpServletRequest request, PayPrintForm form2) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Ctx ctx = wsc.ctx;
        ArrayList<ValueNamePair> paymentRuleList = new ArrayList<ValueNamePair>();
        if (form2.getM_C_BankAccount_ID() == -1) {
            session.setAttribute("paymentRuleList", paymentRuleList);
            return;
        }
        int C_PaySelection_ID = StringToIntConverter.StringToInt(form2.getPaySelect());
        int AD_Reference_ID = 195;
        Language language = Language.getLanguage(Env.getAD_Language(ctx));
        MLookupInfo info = MLookupFactory.getLookup_List(language, AD_Reference_ID);
        String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
                paymentRuleList.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        if (paymentRuleList != null && paymentRuleList.size() > 0 && StringUtils.isEmpty(form2.getPaymentRule())) {
            ValueNamePair pp = (ValueNamePair)paymentRuleList.get(0);
            form2.setPaymentRule(pp.getValue());
        }
        session.setAttribute("paymentRuleList", paymentRuleList);
    }

    public void loadPaymentRuleInfo(HttpServletRequest request, PayPrintForm form2) {
        ResultSet rs;
        CPreparedStatement pstmt;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Ctx ctx = wsc.ctx;
        String PaymentRule = form2.getPaymentRule();
        this.log.info("PaymentRule=" + PaymentRule);
        form2.setNoPayments("");
        int C_PaySelection_ID = StringToIntConverter.StringToInt(form2.getPaySelect());
        String sql = "SELECT COUNT(*) FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                form2.setNoPayments(String.valueOf(rs.getInt(1)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        form2.setEnabledBProcess(PaymentRule.equals("T"));
        sql = "SELECT CurrentNext FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, form2.getM_C_BankAccount_ID());
            pstmt.setString(2, PaymentRule);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                form2.setDocumentNo(String.valueOf(rs.getInt(1)));
            } else {
                this.log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + form2.getM_C_BankAccount_ID() + " AND PaymentRule=" + PaymentRule);
                request.setAttribute(WARNING_INFO, (Object)Msg.getMsg(ctx, "VPayPrintNoDoc"));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }
}

