/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.PayPrint;
import com.ampiere.web.struts.form.PayPrintForm;
import com.jware.util.StringToIntConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MCurrency;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class PayPrintAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ERROR_FORWARD = "error";
    private static final String WARNING_INFO = "warningInfo";
    private static final int FORM_ID = 106;
    private static final String ACTION_TYPE = "";
    private static final String SELECT_ACTION = "1";
    private static final String EXPORT_ACTION = "2";
    private static final String PRINT_ACTION = "3";
    private static final String PROCESS_ACTION = "4";
    private static final int BP_VALUE = 0;
    private static final int BP_NAME = 1;
    private static final int BP_CONTACT = 2;
    private static final int BP_ADDR1 = 3;
    private static final int BP_ADDR2 = 4;
    private static final int BP_CITY = 5;
    private static final int BP_REGION = 6;
    private static final int BP_POSTAL = 7;
    private static final int BP_COUNTRY = 8;
    private static final int BP_REFNO = 9;
    private static final int BPBA_RoutingNo = 0;
    private static final int BPBA_AccountNo = 1;
    private static final int BPBA_AName = 2;
    private static final int BPBA_ACity = 3;
    private static final int BPBA_BBAN = 4;
    private static final int BPBA_IBAN = 5;
    private static final int BA_Name = 6;
    private static final int BA_RoutingNo = 7;
    private static final int BA_SwitftCode = 8;

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        PayPrintForm payPrintForm = (PayPrintForm)form2;
        payPrintForm.statInit(wsc.ctx);
        if (SELECT_ACTION.equals(payPrintForm.getActionType())) {
            PayPrint tmp = new PayPrint();
            tmp.loadPaySelectInfo(request, payPrintForm);
            tmp.loadPaymentRule(request, payPrintForm);
            tmp.loadPaymentRuleInfo(request, payPrintForm);
            payPrintForm.setTitle(Msg.getMsg(wsc.ctx, "PayPrint"));
            session.setAttribute("payPrintForm", (Object)payPrintForm);
        } else {
            if (EXPORT_ACTION.equals(payPrintForm.getActionType())) {
                payPrintForm = (PayPrintForm)session.getAttribute("payPrintForm");
                this.cmd_export(request, response, payPrintForm);
                return null;
            }
            if (PROCESS_ACTION.equals(payPrintForm.getActionType())) {
                this.cmd_EFT(request, payPrintForm);
            }
        }
        if (payPrintForm.isEnabledBProcess()) {
            request.setAttribute("enabledBProcess", (Object)SELECT_ACTION);
        }
        return mapping.findForward("success");
    }

    private void cmd_export(HttpServletRequest request, HttpServletResponse response, PayPrintForm form2) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Ctx ctx = wsc.ctx;
        String PaymentRule = form2.getPaymentRule();
        this.log.info(PaymentRule);
        if (!this.getChecks(request, form2)) {
            return;
        }
        int no = PayPrintAction.exportToResponse(response, form2.getM_checks(), ctx);
    }

    private boolean getChecks(HttpServletRequest request, PayPrintForm form2) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Ctx ctx = wsc.ctx;
        String PaymentRule = form2.getPaymentRule();
        if (StringUtils.isEmpty(form2.getPaySelect()) || form2.getM_C_BankAccount_ID() == -1 || StringUtils.isEmpty(form2.getPaymentRule()) || StringUtils.isEmpty(form2.getDocumentNo())) {
            request.setAttribute(WARNING_INFO, (Object)(Msg.getMsg(ctx, "VPayPrintNoRecords") + Msg.translate(ctx, "C_PaySelectionLine_ID") + "=0)"));
            return false;
        }
        int C_PaySelection_ID = StringToIntConverter.StringToInt(form2.getPaySelect());
        int startDocumentNo = StringToIntConverter.StringToInt(form2.getDocumentNo());
        this.log.config("C_PaySelection_ID=" + C_PaySelection_ID + ", PaymentRule=" + PaymentRule + ", DocumentNo=" + startDocumentNo);
        form2.setM_checks(MPaySelectionCheck.get(C_PaySelection_ID, PaymentRule, startDocumentNo, null));
        if (form2.getM_checks() == null || form2.getM_checks().length == 0) {
            request.setAttribute(WARNING_INFO, (Object)(Msg.getMsg(ctx, "VPayPrintNoRecords") + Msg.translate(ctx, "C_PaySelectionLine_ID") + " #0"));
            return false;
        }
        form2.setM_batch(MPaymentBatch.getForPaySelection(ctx, C_PaySelection_ID, null));
        return true;
    }

    public static int exportToResponse(HttpServletResponse response, MPaySelectionCheck[] checks, Ctx ctx) {
        if (checks == null || checks.length == 0) {
            return 0;
        }
        char x = '\"';
        int noLines = 0;
        StringBuffer line = null;
        try {
            response.setContentType("application/text");
            response.setHeader("Content-Disposition", "inline; filename=paymentExport.txt");
            response.setHeader("Content-Description", "File download for PDF.");
            ServletOutputStream ouputStream = response.getOutputStream();
            line = new StringBuffer();
            line.append(x).append("Value").append(x).append(",").append(x).append("Name").append(x).append(",").append(x).append("Contact").append(x).append(",").append(x).append("Addr1").append(x).append(",").append(x).append("Addr2").append(x).append(",").append(x).append("City").append(x).append(",").append(x).append("State").append(x).append(",").append(x).append("ZIP").append(x).append(",").append(x).append("Country").append(x).append(",").append(x).append("ReferenceNo").append(x).append(",").append(x).append("BPRoutingNo").append(x).append(",").append(x).append("BPAccountNo").append(x).append(",").append(x).append("BPAName").append(x).append(",").append(x).append("BPACity").append(x).append(",").append(x).append("BPBBAN").append(x).append(",").append(x).append("BPIBAN").append(x).append(",").append(x).append("BAName").append(x).append(",").append(x).append("BARoutingNo").append(x).append(",").append(x).append("BASwiftCode").append(x).append(",").append(x).append("DocumentNo").append(x).append(",").append(x).append("PayDate").append(x).append(",").append(x).append("Currency").append(x).append(",").append(x).append("PayAmount").append(x).append(",").append(x).append("Comment").append(x).append(Env.NL);
            ouputStream.print(line.toString());
            ++noLines;
            for (int i2 = 0; i2 < checks.length; ++i2) {
                MPaySelectionCheck mpp = checks[i2];
                if (mpp == null) continue;
                String[] bp = PayPrintAction.getBPartnerInfo(mpp.getC_BPartner_ID());
                String[] bpba = PayPrintAction.getBPBankAccountInfo(mpp.getC_BP_BankAccount_ID());
                StringBuffer comment = new StringBuffer();
                MPaySelectionLine[] psls = mpp.getPaySelectionLines(false);
                for (int l = 0; l < psls.length; ++l) {
                    if (l > 0) {
                        comment.append(", ");
                    }
                    comment.append(psls[l].getInvoice().getDocumentNo());
                }
                line = new StringBuffer();
                line.append(x).append(bp[0]).append(x).append(",").append(x).append(bp[1]).append(x).append(",").append(x).append(bp[2]).append(x).append(",").append(x).append(bp[3]).append(x).append(",").append(x).append(bp[4]).append(x).append(",").append(x).append(bp[5]).append(x).append(",").append(x).append(bp[6]).append(x).append(",").append(x).append(bp[7]).append(x).append(",").append(x).append(bp[8]).append(x).append(",").append(x).append(bp[9]).append(x).append(",").append(x).append(bpba[0]).append(x).append(",").append(x).append(bpba[1]).append(x).append(",").append(x).append(bpba[2]).append(x).append(",").append(x).append(bpba[3]).append(x).append(",").append(x).append(bpba[4]).append(x).append(",").append(x).append(bpba[5]).append(x).append(",").append(x).append(bpba[6]).append(x).append(",").append(x).append(bpba[7]).append(x).append(",").append(x).append(bpba[8]).append(x).append(",").append(x).append(mpp.getDocumentNo()).append(x).append(",").append(mpp.getParent().getPayDate()).append(",").append(x).append(MCurrency.getISO_Code(ctx, mpp.getParent().getC_Currency_ID())).append(x).append(",").append(mpp.getPayAmt()).append(",").append(x).append(comment.toString()).append(x).append(Env.NL);
                ouputStream.print(line.toString());
                ++noLines;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return noLines;
    }

    private static String[] getBPartnerInfo(int C_BPartner_ID) {
        String[] bp = new String[10];
        String sql = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp LEFT OUTER JOIN AD_User c ON (bp.C_BPartner_ID=c.C_BPartner_ID) INNER JOIN C_BPartner_Location l ON (bp.C_BPartner_ID=l.C_BPartner_ID) INNER JOIN C_Location a ON (l.C_Location_ID=a.C_Location_ID) LEFT OUTER JOIN C_Region r ON (a.C_Region_ID=r.C_Region_ID) INNER JOIN C_Country cc ON (a.C_Country_ID=cc.C_Country_ID) WHERE bp.C_BPartner_ID=?ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                bp[0] = rs.getString(1);
                if (bp[0] == null) {
                    bp[0] = ACTION_TYPE;
                }
                bp[1] = rs.getString(2);
                if (bp[1] == null) {
                    bp[1] = ACTION_TYPE;
                }
                bp[2] = rs.getString(3);
                if (bp[2] == null) {
                    bp[2] = ACTION_TYPE;
                }
                bp[3] = rs.getString(4);
                if (bp[3] == null) {
                    bp[3] = ACTION_TYPE;
                }
                bp[4] = rs.getString(5);
                if (bp[4] == null) {
                    bp[4] = ACTION_TYPE;
                }
                bp[5] = rs.getString(6);
                if (bp[5] == null) {
                    bp[5] = ACTION_TYPE;
                }
                bp[6] = rs.getString(7);
                if (bp[6] == null) {
                    bp[6] = ACTION_TYPE;
                }
                bp[7] = rs.getString(8);
                if (bp[7] == null) {
                    bp[7] = ACTION_TYPE;
                }
                bp[8] = rs.getString(9);
                if (bp[8] == null) {
                    bp[8] = ACTION_TYPE;
                }
                bp[9] = rs.getString(10);
                if (bp[9] == null) {
                    bp[9] = ACTION_TYPE;
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bp;
    }

    private static String[] getBPBankAccountInfo(int C_BP_BankAccount_ID) {
        String[] bp = new String[10];
        String sql = "SELECT bpba.RoutingNo, bpba.AccountNo, bpba.A_Name, bpba.A_City, bpba.BBAN, bpba.IBAN, ba.Name, ba.RoutingNo, ba.SwiftCode FROM C_BP_BankAccount bpba LEFT OUTER JOIN C_Bank ba ON (bpba.C_Bank_ID = ba.C_Bank_ID) WHERE bpba.C_BP_BankAccount_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BP_BankAccount_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                bp[0] = rs.getString(1);
                if (bp[0] == null) {
                    bp[0] = ACTION_TYPE;
                }
                bp[1] = rs.getString(2);
                if (bp[1] == null) {
                    bp[1] = ACTION_TYPE;
                }
                bp[2] = rs.getString(3);
                if (bp[2] == null) {
                    bp[2] = ACTION_TYPE;
                }
                bp[3] = rs.getString(4);
                if (bp[3] == null) {
                    bp[3] = ACTION_TYPE;
                }
                bp[4] = rs.getString(5);
                if (bp[4] == null) {
                    bp[4] = ACTION_TYPE;
                }
                bp[5] = rs.getString(6);
                if (bp[5] == null) {
                    bp[5] = ACTION_TYPE;
                }
                bp[6] = rs.getString(7);
                if (bp[6] == null) {
                    bp[6] = ACTION_TYPE;
                }
                bp[7] = rs.getString(8);
                if (bp[7] == null) {
                    bp[7] = ACTION_TYPE;
                }
                bp[8] = rs.getString(9);
                if (bp[8] == null) {
                    bp[8] = ACTION_TYPE;
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bp;
    }

    private void cmd_EFT(HttpServletRequest request, PayPrintForm form2) {
        String PaymentRule = form2.getPaymentRule();
        this.log.info(PaymentRule);
        if (!this.getChecks(request, form2)) {
            return;
        }
    }
}

