/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.search.ColBean;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.form.TrxMaterialForm;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrxMaterialAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ORDER_LIST = "orderlist";
    private static final String SHIPMENT_LIST = "shipmentlist";
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";
    private static final String ERROR_FORWARD = "error";
    private static final int ORDER_BUSINESS_PARTNER_COLUMN_ID = 2762;
    private static final int FORM_ID = 110;

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        TrxMaterialForm trxMaterialForm = (TrxMaterialForm)form2;
        ArrayList<ColBean> result = this.getList(request, trxMaterialForm);
        session.setAttribute("searchResultTrxMaterial", result);
        trxMaterialForm.setTitle(Msg.getMsg(wsc.ctx, "TrxMaterial"));
        request.setAttribute("trxMaterialForm", (Object)trxMaterialForm);
        return mapping.findForward("success");
    }

    private ArrayList<ColBean> getList(HttpServletRequest request, TrxMaterialForm form2) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        int AD_Window_ID = 223;
        boolean m_WindowNo = false;
        WWindowStatus ws = WWindowStatus.get(request);
        GridWindowVO wVO = null;
        if (ws == null) {
            wVO = GridWindowVO.create(wsc.ctx, 1, AD_Window_ID, 0);
            ws = new WWindowStatus(wVO);
            WWindowStatus.set(request, ws.getCurTab().getAD_Window_ID(), ws);
        } else {
            wVO = GridWindowVO.create(wsc.ctx, ws.getCurTab().getWindowNo() + 1, AD_Window_ID, 0);
        }
        if (wVO == null) {
            return null;
        }
        GridWindow m_mWindow = new GridWindow(wVO);
        GridTab m_mTab = m_mWindow.getTab(0);
        m_mTab.setQuery(this.getQuery(request, form2));
        m_mTab.query(0);
        ArrayList resultList = this.executeQuery(request, m_mTab);
        return resultList;
    }

    public ArrayList executeQuery(HttpServletRequest request, GridTab tab) {
        ArrayList<ColBean> resultList = new ArrayList<ColBean>();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Ctx ctx = wsc.ctx;
        for (int i2 = 0; i2 < tab.getRowCount(); ++i2) {
            ColBean colBean = new ColBean();
            int colOffset = 0;
            int beanOffset = 0;
            for (int col = 0; col < tab.getFieldCount(); ++col) {
                GridField field = tab.getField(col);
                Object data = null;
                int displayType = field.getDisplayType();
                int colIndex = col + colOffset;
                String style = "";
                Object test = ws.getCurTab().getValue(field);
                if (DisplayType.isID(displayType)) {
                    data = tab.getValue(i2, field.getColumnName());
                } else if (displayType == 20) {
                    data = tab.getValue(i2, field.getColumnName());
                    if (data == null || "".equals(data)) {
                        data = "N";
                    }
                    style = style + "text-align: center;";
                } else if (DisplayType.isDate(displayType)) {
                    data = tab.getValue(i2, field.getColumnName());
                    data = wsc.dateFormat.format(data);
                    style = style + "white-space: nowrap;";
                } else if (DisplayType.isNumeric(displayType)) {
                    data = tab.getValue(i2, field.getColumnName());
                    style = style + "text-align: right;";
                } else if (displayType == 11) {
                    data = tab.getValue(i2, field.getColumnName());
                    style = style + "text-align: right;";
                } else {
                    data = tab.getValue(i2, field.getColumnName());
                }
                if (field.getLookup() != null) {
                    data = field.getLookup().get(data);
                }
                colBean.setColData(beanOffset, data);
                colBean.setStyle(beanOffset, style);
                colBean.setColTitle(colIndex, Msg.translate(ctx, field.getColumnName()));
                if (field.isKey()) {
                    colBean.setColId(data.toString());
                    String colName = data.toString();
                    colBean.setColName(colName);
                }
                ++beanOffset;
            }
            resultList.add(colBean);
        }
        return resultList;
    }

    private Query getQuery(HttpServletRequest request, TrxMaterialForm form2) {
        String fDateTo;
        String fDateFrom;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Query query = new Query();
        query.addRestriction("AD_Client_ID", "=", wsc.ctx.getAD_Client_ID());
        String value = form2.getOrg();
        if (value != null && value.toString().length() > 0) {
            query.addRestriction("AD_Org_ID", "=", value);
        }
        if ((value = form2.getLocator()) != null && value.toString().length() > 0) {
            query.addRestriction("M_Locator_ID", "=", value);
        }
        if ((value = form2.getProductd()) != null && value.toString().length() > 0) {
            query.addRestriction("M_Product_ID", "=", value);
        }
        if ((value = form2.getMtype()) != null && value.toString().length() > 0) {
            query.addRestriction("MovementType", "=", value);
        }
        if (!StringUtils.isEmpty(fDateFrom = form2.getDateF())) {
            try {
                Timestamp from = null;
                try {
                    from = new Timestamp(wsc.dateFormat.parse(fDateFrom).getTime());
                }
                catch (Exception e) {
                    from = null;
                }
                query.addRestriction("TRUNC(MovementDate,'DD')", ">=", from);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty(fDateTo = form2.getDateT())) {
            try {
                Timestamp to = null;
                try {
                    to = new Timestamp(wsc.dateFormat.parse(fDateTo).getTime());
                }
                catch (Exception e) {
                    to = null;
                }
                query.addRestriction("TRUNC(MovementDate,'DD')", "<=", to);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return query;
    }
}

