/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.search;

import com.ampiere.dto.CodeValue;
import com.ampiere.web.struts.common.PopupBaseForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MRole;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProductForm
extends PopupBaseForm {
    private static final long serialVersionUID = -2979814699715706579L;
    private String name;
    private String nameLabel;
    private String upc;
    private String upcLabel;
    private String sku;
    private String skuLabel;
    private String warehouse;
    private String warehouseLabel;
    private String priceListVersion;
    private String priceListVersionLabel;
    private String paSearchFlag = "false";
    private String paSearchWhere = "";
    private ArrayList<CodeValue> warehouseList = new ArrayList();
    private ArrayList<CodeValue> priceList = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameLabel() {
        return this.nameLabel;
    }

    public void setNameLabel(String nameLabel) {
        this.nameLabel = nameLabel;
    }

    public String getPriceListVersion() {
        return this.priceListVersion;
    }

    public void setPriceListVersion(String priceListVersion) {
        this.priceListVersion = priceListVersion;
    }

    public String getPriceListVersionLabel() {
        return this.priceListVersionLabel;
    }

    public void setPriceListVersionLabel(String priceListVersionLabel) {
        this.priceListVersionLabel = priceListVersionLabel;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getSkuLabel() {
        return this.skuLabel;
    }

    public void setSkuLabel(String skuLabel) {
        this.skuLabel = skuLabel;
    }

    public String getUpc() {
        return this.upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public String getUpcLabel() {
        return this.upcLabel;
    }

    public void setUpcLabel(String upcLabel) {
        this.upcLabel = upcLabel;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public String getWarehouseLabel() {
        return this.warehouseLabel;
    }

    public void setWarehouseLabel(String warehouseLabel) {
        this.warehouseLabel = warehouseLabel;
    }

    public String getPaSearchWhere() {
        return this.paSearchWhere;
    }

    public void setPaSearchWhere(String paSearchWhere) {
        this.paSearchWhere = paSearchWhere;
    }

    public String getPaSearchFlag() {
        return this.paSearchFlag;
    }

    public void setPaSearchFlag(String paSearchFlag) {
        this.paSearchFlag = paSearchFlag;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
    }

    @Override
    public void statInit(Ctx ctx) {
        super.statInit(ctx);
        this.setTitle(Msg.translate(ctx, "InfoProduct"));
        this.setValueLabel(Msg.translate(ctx, "Value"));
        this.setNameLabel(Msg.translate(ctx, "Name"));
        this.setUpcLabel(Msg.translate(ctx, "UPC"));
        this.setSkuLabel(Msg.translate(ctx, "SKU"));
        this.setWarehouseLabel(Msg.translate(ctx, "Warehouse"));
        this.setPriceListVersionLabel(Msg.translate(ctx, "PriceListVersion"));
    }

    public void initInfo(String value, int M_PriceList_ID, int M_Warehouse_ID, Ctx ctx, int windowNo) {
        this.getDataLists(ctx, M_PriceList_ID);
        int M_PriceList_Version_ID = this.findPLV(M_PriceList_ID, ctx, windowNo);
        if (value.startsWith("@") && value.endsWith("@")) {
            this.name = value.substring(1, value.length() - 1);
        } else {
            this.setValue(value);
        }
        if (M_Warehouse_ID == 0) {
            M_Warehouse_ID = ctx.getContextAsInt("#M_Warehouse_ID");
        }
        if (M_Warehouse_ID != 0) {
            this.setWarehouse(Integer.toString(M_Warehouse_ID));
        }
        if (M_PriceList_Version_ID != 0) {
            this.setPriceListVersion(Integer.toString(M_PriceList_Version_ID));
        }
    }

    private void getDataLists(Ctx ctx, int M_PriceList_ID) {
        this.warehouseList.clear();
        this.priceList.clear();
        String SQL = "SELECT M_PriceList_Version.M_PriceList_Version_ID, M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName FROM M_PriceList_Version, M_PriceList pl, C_Currency c WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=c.C_Currency_ID AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
        if (M_PriceList_ID != 0) {
            SQL = SQL + " AND EXISTS (SELECT * FROM M_PriceList xp WHERE xp.M_PriceList_ID=" + M_PriceList_ID + " AND pl.C_Currency_ID=xp.C_Currency_ID)";
        }
        SQL = MRole.getDefault(ctx, false).addAccessSQL(SQL, "M_PriceList_Version", true, false) + " ORDER BY M_PriceList_Version.Name";
        try {
            this.priceList.add(new CodeValue("0", ""));
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.priceList.add(new CodeValue(rs.getString(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
            SQL = MRole.getDefault(ctx, false).addAccessSQL("SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName FROM M_Warehouse WHERE IsActive='Y'", "M_Warehouse", false, false) + " ORDER BY Value";
            this.warehouseList.add(new CodeValue("0", ""));
            pstmt = DB.prepareStatement(SQL, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.warehouseList.add(new CodeValue(rs.getString("M_Warehouse_ID"), rs.getString("ValueName")));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int findPLV(int M_PriceList_ID, Ctx ctx, int windowNo) {
        Timestamp priceDate = null;
        String dateStr = ctx.getContext(windowNo, "DateOrdered");
        if (dateStr != null && dateStr.length() > 0) {
            priceDate = new Timestamp(ctx.getContextAsTime(windowNo, "DateOrdered"));
        } else {
            dateStr = ctx.getContext(windowNo, "DateInvoiced");
            if (dateStr != null && dateStr.length() > 0) {
                priceDate = new Timestamp(ctx.getContextAsTime(windowNo, "DateInvoiced"));
            }
        }
        if (priceDate == null) {
            priceDate = new Timestamp(System.currentTimeMillis());
        }
        int retValue = 0;
        String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom FROM M_PriceList pl, M_PriceList_Version plv WHERE pl.M_PriceList_ID=plv.M_PriceList_ID AND plv.IsActive='Y' AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next() && retValue == 0) {
                Timestamp plDate = rs.getTimestamp(2);
                if (priceDate.before(plDate)) continue;
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ctx.setContext(windowNo, "M_PriceList_Version_ID", retValue);
        return retValue;
    }

    public ArrayList<CodeValue> getPriceList() {
        return this.priceList;
    }

    public ArrayList<CodeValue> getWarehouseList() {
        return this.warehouseList;
    }
}

