/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.jobs;

import com.jware.apps.scheduler.jobs.DumbJob;
import com.jware.apps.scheduler.jobs.MyJobListener;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class ListenerTest {
    public static void schedTest(SchedulerFactory sf) throws Exception {
        Log lg = LogFactory.getLog(ListenerTest.class);
        lg.info((Object)"------- Initializing -------------------");
        Scheduler sched = sf.getScheduler();
        sched.addGlobalJobListener((JobListener)new MyJobListener("myListener1"));
        sched.addJobListener((JobListener)new MyJobListener("myListener2"));
        sched.unscheduleJob("trigg1", "group1");
        lg.info((Object)"------- Initialization Complete -----------");
        lg.info((Object)"------- Scheduling Jobs -----------");
        long ts = System.currentTimeMillis() + 4000L;
        JobDetail job = new JobDetail("job1", "group1", DumbJob.class);
        job.addJobListener("myListener2");
        SimpleTrigger trigger = new SimpleTrigger("trigg1", "group1", "job1", "group1", new Date(ts), null, 0, 0L);
        lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        sched.scheduleJob(job, (Trigger)trigger);
        job = new JobDetail("job2", "group1", DumbJob.class);
        trigger = new SimpleTrigger("trigg2", "group1", "job2", "group1", new Date(ts + 4000L), null, 0, 0L);
        lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        sched.scheduleJob(job, (Trigger)trigger);
        lg.info((Object)"------- Starting Scheduler ----------------");
        sched.start();
        lg.info((Object)"------- Started Scheduler -----------------");
        lg.info((Object)"------- Waiting... -----------------------");
        try {
            Thread.sleep(30000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lg.info((Object)"------- Shutting Down ---------------------");
        sched.shutdown();
        lg.info((Object)"------- Shutdown Complete -----------------");
    }

    public static void main(String[] args) throws Exception {
        try {
            ListenerTest.schedTest((SchedulerFactory)new StdSchedulerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

