/*
 * Decompiled with CFR 0.152.
 */
package com.jware.base.web.struts;

import com.jware.base.error.JwareApplicationException;
import com.jware.base.web.struts.AccessHistory;
import com.jware.base.web.struts.IMochaConstants;
import com.jware.base.web.struts.JwareHttpServletRequestWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public abstract class BaseAction
extends Action
implements IMochaConstants {
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    private static final int MAX_HISTORY = 64;
    private static ServletContext context = null;
    private static boolean initialized = false;
    protected Class clazz_ = this.getClass();
    protected HashMap methods_ = new HashMap();
    protected Class[] types_ = new Class[]{ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class, ActionErrors.class};

    public ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        ActionErrors errors;
        ActionErrors validateErrors;
        block24: {
            validateErrors = this.getErrors(request);
            if (validateErrors == null) {
                validateErrors = new ActionErrors();
            }
            errors = new ActionErrors();
            forward = null;
            HttpSession session = request.getSession();
            Object loginInfo = session.getAttribute("LoginInfo");
            if (loginInfo == null) {
                ActionForward loginForward = mapping.findForward("login");
                if (loginForward != null) {
                    this.log.info((Object)("Login Action Forward :=" + loginForward.getPath()));
                    return loginForward;
                }
                this.log.info((Object)"Login Action Forward not exsit......");
            }
            String parameter = mapping.getParameter();
            String methodName = null;
            if (parameter != null) {
                methodName = request.getParameter(parameter);
            }
            try {
                if (parameter == null || methodName == null) {
                    forward = this.doExecute(mapping, form2, request, response, errors);
                    break block24;
                }
                Method method = null;
                try {
                    method = this.getMethod(methodName);
                    Object[] args = new Object[]{mapping, form2, request, response, errors};
                    forward = (ActionForward)method.invoke((Object)this, args);
                }
                catch (NoSuchMethodException e) {
                    this.log.error((Object)("method doesnt exist :" + methodName), (Throwable)e);
                    return mapping.findForward("failure");
                }
                catch (ClassCastException e) {
                    this.log.error((Object)("return value is invalid:" + methodName), (Throwable)e);
                    return mapping.findForward("failure");
                }
                catch (IllegalAccessException e) {
                    this.log.error((Object)("method doesnt exist :" + methodName), (Throwable)e);
                    return mapping.findForward("failure");
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (JwareApplicationException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)e);
                }
                forward = this.getForwardWithExceptions(mapping, form2, request, response, e, errors);
            }
            catch (Throwable ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)ex);
                }
                ex.printStackTrace();
                forward = mapping.findForward("failure");
            }
        }
        if (this.isDisplayTagExporting(mapping, request, response)) {
            ActionForward exportForward = mapping.findForward("export");
            if (exportForward != null) {
                forward = exportForward;
            }
        } else {
            this.setHistoryBackUrl(mapping, form2, request, response, forward);
        }
        ActionForward postTOGetForward = mapping.findForward("PostToGetCommonForward");
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            ActionForward prevForward;
            if (postTOGetForward != null && errors.isEmpty() && validateErrors.isEmpty()) {
                if (forward.getPath().indexOf(".do") > 0) {
                    String forwardPath = forward.getPath();
                    while (forwardPath.indexOf("/") >= 0) {
                        forwardPath = forwardPath.substring(forwardPath.indexOf("/") + 1);
                    }
                    request.setAttribute("PostToGetCommonForward", (Object)forwardPath);
                    forward = postTOGetForward;
                }
            } else if (!validateErrors.isEmpty() && form2 == null && forward.getPath().indexOf(".do") > 0 && (prevForward = this.getPrevForward(mapping, form2, request, response, 1)) != null) {
                forward = prevForward;
            }
        }
        this.addErrors(request, errors);
        return forward;
    }

    protected void setHistoryBackUrl(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionForward forward) {
        int insertPoint;
        Cookie[] cookies;
        HttpSession session = request.getSession();
        LinkedList<AccessHistory> historyList = (LinkedList<AccessHistory>)session.getAttribute("AccessHistory");
        if (historyList == null) {
            historyList = new LinkedList<AccessHistory>();
        }
        AccessHistory accessHistory = new AccessHistory();
        String uri = request.getRequestURI();
        if (uri != null) {
            accessHistory.setUri(uri);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Action URI = " + uri));
            }
        } else {
            accessHistory.setUri(null);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Action URI = NULL");
            }
        }
        if ((cookies = request.getCookies()) != null) {
            for (int i2 = 0; i2 < cookies.length; ++i2) {
                Cookie cookie = cookies[i2];
                if (!"PREVURI".equalsIgnoreCase(cookie.getName())) continue;
                accessHistory.setPrevUri(cookie.getValue());
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Action PREVURI = " + accessHistory.getPrevUri()));
            }
        }
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        LinkedList<String> parameterNameList = new LinkedList<String>();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            parameterNameList.add(parameterName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("parameterName = " + parameterName));
            }
            String[] parameterValues = request.getParameterValues(parameterName);
            parameterMap.put(parameterName, parameterValues);
            if (!this.log.isDebugEnabled()) continue;
            for (int j = 0; j < parameterValues.length; ++j) {
                this.log.debug((Object)("parameterValues[" + j + "] = " + parameterValues[j]));
            }
        }
        accessHistory.setParameterNames(parameterNameList);
        accessHistory.setParameterMap(parameterMap);
        accessHistory.setForm(baseForm);
        accessHistory.setForward(forward);
        Enumeration requestNames = request.getAttributeNames();
        LinkedList<String> requestNameList = new LinkedList<String>();
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        while (requestNames.hasMoreElements()) {
            String requestName = (String)requestNames.nextElement();
            requestNameList.add(requestName);
            requestMap.put(requestName, request.getAttribute(requestName));
        }
        accessHistory.setRequestNames(requestNameList);
        accessHistory.setRequestMap(requestMap);
        Enumeration sessionNames = session.getAttributeNames();
        LinkedList<String> sessionNameList = new LinkedList<String>();
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        while (sessionNames.hasMoreElements()) {
            String sessionName = (String)sessionNames.nextElement();
            if ("AccessHistory".equals(sessionName)) continue;
            sessionNameList.add(sessionName);
            sessionMap.put(sessionName, session.getAttribute(sessionName));
        }
        accessHistory.setSessionNames(sessionNameList);
        accessHistory.setSessionMap(sessionMap);
        for (insertPoint = 0; insertPoint < historyList.size(); ++insertPoint) {
            AccessHistory tempHistory = (AccessHistory)historyList.get(insertPoint);
            if (accessHistory.getPrevUri() != null && accessHistory.getPrevUri().indexOf(tempHistory.getForward().getPath()) >= 0) break;
        }
        if (insertPoint >= historyList.size()) {
            insertPoint = 0;
        }
        if (accessHistory.getForward() != null) {
            historyList.add(insertPoint, accessHistory);
        }
        while (historyList.size() > 64) {
            historyList.remove(64);
        }
        session.setAttribute("AccessHistory", historyList);
    }

    public abstract ActionForward doExecute(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4, ActionErrors var5) throws JwareApplicationException;

    protected ActionForward getForwardWithExceptions(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, JwareApplicationException ex, ActionErrors errors) {
        List exceptions;
        ActionForward forward = null;
        this.convertExceptionsToActionErrors(errors, ex);
        String inputForward = mapping.getInput();
        ActionForward errorForward = mapping.findForward("error");
        if (inputForward != null && (forward = mapping.getInputForward()) == null) {
            forward = this.getPrevForward(mapping, form2, request, response, 0);
        }
        if (forward == null) {
            forward = errorForward;
        }
        if ((exceptions = ex.getExceptions()) != null && !exceptions.isEmpty()) {
            for (JwareApplicationException childException : exceptions) {
                this.convertExceptionsToActionErrors(errors, childException);
            }
        }
        return forward;
    }

    protected ActionForward getPrevForward(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, int skipNumber) {
        ActionForward forward = null;
        HttpSession session = request.getSession();
        LinkedList historyList = (LinkedList)session.getAttribute("AccessHistory");
        AccessHistory accessHistory = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("history List Size = " + historyList.size()));
        }
        if (historyList != null && historyList.size() > 1) {
            if (historyList.size() > skipNumber + 1) {
                int currentPoint = skipNumber;
                accessHistory = (AccessHistory)historyList.get(currentPoint);
                while (skipNumber > 0) {
                    historyList.remove(0);
                    --skipNumber;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("accessHistory URL = " + accessHistory.getUri()));
            }
            forward = accessHistory.getForward();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("history set forward path = " + forward.getPath()));
            }
            form2 = accessHistory.getForm();
            List requestNameList = accessHistory.getRequestNames();
            Map requestMap = accessHistory.getRequestMap();
            for (int i2 = 0; i2 < requestNameList.size(); ++i2) {
                String requestName = (String)requestNameList.get(i2);
                request.setAttribute(requestName, requestMap.get(requestName));
            }
            List sessionNameList = accessHistory.getSessionNames();
            Map sessionMap = accessHistory.getSessionMap();
            for (int i3 = 0; i3 < sessionNameList.size(); ++i3) {
                String sessionName = (String)sessionNameList.get(i3);
                session.setAttribute(sessionName, sessionMap.get(sessionName));
            }
            List parameterNameList = accessHistory.getParameterNames();
            Map parameterMap = accessHistory.getParameterMap();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("1. Parameter Map Size = " + parameterMap.size()));
            }
            JwareHttpServletRequestWrapper requestWrapper = new JwareHttpServletRequestWrapper((HttpServletRequest)request);
            requestWrapper.setRequestURI(accessHistory.getUri());
            for (int i4 = 0; i4 < parameterNameList.size(); ++i4) {
                String parameterName = (String)parameterNameList.get(i4);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" Parameter Name = " + parameterName));
                }
                String[] parameterValues = (String[])parameterMap.get(parameterName);
                for (int j = 0; j < parameterValues.length; ++j) {
                    this.log.debug((Object)("parameterValues[" + j + "] = " + parameterValues[j]));
                }
                requestWrapper.setParameterValues(parameterName, parameterValues);
            }
            request = requestWrapper;
        }
        return forward;
    }

    protected void convertExceptionsToActionErrors(ActionErrors errors, JwareApplicationException ex) {
        ActionMessage message = null;
        String errCode = ex.getMessageKey();
        Object[] args = ex.getMessageBundleValues();
        message = args != null && args.length > 0 ? new ActionMessage("error.code." + errCode, args) : new ActionMessage("error.code." + errCode);
        errors.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getMethod(String name) throws NoSuchMethodException {
        HashMap hashMap = this.methods_;
        synchronized (hashMap) {
            Method method = (Method)this.methods_.get(name);
            if (method == null) {
                method = this.clazz_.getMethod(name, this.types_);
                this.methods_.put(name, method);
            }
            return method;
        }
    }

    public static ServletContext getContext() {
        return context;
    }

    public boolean isDisplayTagExporting(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) {
        boolean exporting = false;
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (paramName.indexOf("d-") != 0 || paramName.indexOf("-e") <= 0) continue;
            exporting = true;
            break;
        }
        return exporting;
    }

    protected void setActionMessages(ActionErrors errors, String key) {
        this.setActionMessages(errors, key, null);
    }

    protected void setActionMessages(ActionErrors errors, String key, Object[] args) {
        ActionMessage message = null;
        message = args != null && args.length > 0 ? new ActionMessage(key, args) : new ActionMessage(key);
        if (message != null) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
        }
    }
}

