/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util;

import com.jware.base.error.JwareApplicationException;
import com.jware.util.DateUtils;
import com.jware.util.FileUploader;
import java.io.File;
import java.util.List;
import org.apache.struts.upload.FormFile;

public class JwareUploader {
    private FileUploader uploader;
    private String filePath;
    private FormFile formFile;

    public JwareUploader(FormFile formFile, String filePath) {
        this.filePath = filePath;
        this.formFile = formFile;
    }

    public List executeWithZipExtract(boolean extractFlg) throws JwareApplicationException {
        List fileNames = null;
        String fileName = this.formFile.getFileName();
        if (!"".equals(fileName)) {
            this.uploader = new FileUploader(this.formFile);
            fileNames = this.uploader.executeWithZipExtract("java.resources.UtilResource", this.filePath, extractFlg);
        }
        return fileNames;
    }

    public String execute() throws JwareApplicationException {
        String fileName = this.formFile.getFileName();
        String imageFileName = null;
        if ("".equals(fileName)) {
            imageFileName = fileName;
        } else {
            imageFileName = this.getFileName(fileName);
            this.uploader = new FileUploader(this.formFile);
            this.uploader.setFileName(imageFileName);
            this.uploader.execute("java.resources.UtilResource", this.filePath);
        }
        return imageFileName;
    }

    public String execute(String uploadfileName) throws JwareApplicationException {
        String fileName = this.formFile.getFileName();
        String imageFileName = uploadfileName;
        imageFileName = this.adjustFileExtension(fileName, uploadfileName);
        if (!"".equals(fileName)) {
            String fullpath = this.filePath + System.getProperty("file.separator") + imageFileName;
            File file = new File(fullpath);
            if (file.exists()) {
                imageFileName = this.getFileName(fileName);
            }
            this.uploader = new FileUploader(this.formFile);
            this.uploader.setFileName(imageFileName);
            this.uploader.execute("java.resources.UtilResource", this.filePath);
        }
        return imageFileName;
    }

    private String getFileName(String fileName) {
        if (fileName == null || "".equals(fileName.trim())) {
            return "";
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String extension = fileName.substring(index);
        if ("".equals(extension)) {
            extension = ".txt";
        } else if ("jpeg".equals(extension)) {
            extension = ".jpg";
        }
        String[] arr = DateUtils.getYYYYMMDDHHMISSArray();
        String saveFileName = "img" + arr[0] + arr[1] + arr[2] + arr[3] + arr[4] + arr[5] + extension;
        return saveFileName;
    }

    private String adjustFileExtension(String oldName, String newName) {
        String newFileName = newName;
        if (oldName == null || "".equals(oldName.trim())) {
            return "";
        }
        int index = oldName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String extension = oldName.substring(index);
        if (newName == null || "".equals(newName.trim())) {
            return "";
        }
        index = newName.lastIndexOf(46);
        newFileName = index >= 0 ? newName.substring(0, index) + extension : newName + extension;
        return newFileName;
    }
}

