/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.Lookup;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;

public class WAccount
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(WAccount.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WAccount.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("WAccount.doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String formName = WebUtil.getParameter(request, "FormName");
        String columnName = WebUtil.getParameter(request, "ColumnName");
        GridField mField = ws.curTab.getField(columnName);
        log.config("FormName=" + formName + ", ColumnName=" + columnName + ", MField=" + mField.toString());
        if (mField == null || formName == null || columnName == null || formName.equals("") || columnName.equals("")) {
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        String target = "opener.document." + formName + "." + columnName;
        WebDoc doc = WebDoc.create(mField.getHeader());
        body body2 = doc.getBody();
        body2.setOnBlur("self.focus();");
        body2.addElement((Element)this.fillTable(ws, mField, target));
        button reset = new button();
        reset.addElement("Reset");
        reset.setOnClick(target + ".value='';" + target + "_D.value='';window.close();");
        button cancel = new button();
        cancel.addElement("Cancel");
        cancel.setOnClick("window.close();");
        body2.addElement((Element)new p("right").addElement((Element)reset).addElement("&nbsp").addElement((Element)cancel));
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.config("WAccount.doPost");
        this.doGet(request, response);
    }

    private table fillTable(WWindowStatus ws, GridField mField, String target) {
        table table2 = new table("1");
        tr line = new tr();
        line.addElement((Element)new th("&nbsp")).addElement((Element)new th(Msg.translate(ws.ctx, "Name")));
        table2.addElement((Element)line);
        Lookup lookup = mField.getLookup();
        lookup.fillComboBox(mField.isMandatory(false), true, true, true);
        int size = lookup.getSize();
        for (int i2 = 0; i2 < size; ++i2) {
            Object lValue = lookup.getElementAt(i2);
            if (lValue == null || !(lValue instanceof KeyNamePair)) continue;
            KeyNamePair np = (KeyNamePair)lValue;
            button button2 = new button();
            button2.addElement("&gt;");
            StringBuffer script2 = new StringBuffer(target);
            script2.append(".value='").append(np.getKey()).append("';").append(target).append("_D.value='").append(np.getName()).append("';window.close();");
            button2.setOnClick(script2.toString());
            line = new tr();
            line.addElement((Element)new td((Element)button2));
            String name = np.getName();
            if (name == null || name.length() == 0) {
                name = "&nbsp";
            }
            line.addElement((Element)new td(name));
            table2.addElement((Element)line);
        }
        lookup.fillComboBox(true);
        return table2;
    }
}

