/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.hr;
import org.compiere.model.MStore;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.HtmlCode;
import org.compiere.util.Msg;
import org.compiere.util.WebInfo;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUser;
import org.compiere.wstore.JSPEnv;

public class InfoLinkTag
extends TagSupport {
    private static final long serialVersionUID = 7608741032814139346L;
    private static CLogger log = CLogger.getCLogger(InfoLinkTag.class);
    private boolean m_oneLine = false;

    public void setOneLine(String var) {
        this.m_oneLine = "Y".equals(var);
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Ctx ctx = JSPEnv.getCtx(request);
        WebSessionCtx wsc = WebSessionCtx.get(request, true);
        HttpSession session = this.pageContext.getSession();
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu != null && wu.isLoggedIn()) {
            WebInfo info;
            if (ctx != null && ((info = (WebInfo)session.getAttribute("info")) == null || wu.getAD_User_ID() != info.getAD_User_ID())) {
                info = new WebInfo(ctx, wu);
                session.setAttribute("info", (Object)info);
            }
            JspWriter out = this.pageContext.getOut();
            HtmlCode html = new HtmlCode();
            if (wu.isCustomer() || wu.isVendor()) {
                this.menuBPartner(html, wsc.wstore);
            }
            if (wu.isSalesRep()) {
                this.menuSalesRep(html, wsc.wstore);
            }
            if (wu.isEmployee() || wu.isSalesRep()) {
                this.menuUser(html, wu.isEmployee(), wsc.wstore);
            }
            this.menuAll(html, wsc.wstore);
            html.output((Writer)out);
        } else {
            if (CLogMgt.isLevelFiner()) {
                log.fine("No WebUser");
            }
            if (session.getAttribute("info") == null) {
                session.setAttribute("info", (Object)WebInfo.getGeneral());
            }
        }
        return 0;
    }

    private void menuBPartner(HtmlCode html, MStore wstore) {
        a a2;
        Ctx ctx = JSPEnv.getCtx((HttpServletRequest)this.pageContext.getRequest());
        boolean first = true;
        if (wstore.isMenuAssets()) {
            this.nl(html, first);
            first = false;
            a2 = new a("assets.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "A_Asset_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuInvoices()) {
            this.nl(html, first);
            first = false;
            a2 = new a("invoices.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "C_Invoice_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuPayments()) {
            this.nl(html, first);
            first = false;
            a2 = new a("payments.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "C_Payment_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuOrders()) {
            this.nl(html, first);
            first = false;
            a2 = new a("orders.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "C_Order_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuShipments()) {
            this.nl(html, first);
            first = false;
            a2 = new a("shipments.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "M_InOut_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuRfQs()) {
            this.nl(html, first);
            first = false;
            a2 = new a("rfqs.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "C_RfQ_ID"));
            html.addElement((Element)a2);
        }
    }

    private void menuAll(HtmlCode html, MStore wstore) {
        a a2;
        Ctx ctx = JSPEnv.getCtx((HttpServletRequest)this.pageContext.getRequest());
        boolean first = false;
        if (wstore.isMenuRequests()) {
            this.nl(html, first);
            a2 = new a("requests.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "R_Request_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuInterests()) {
            this.nl(html, first);
            a2 = new a("info.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "R_InterestArea_ID"));
            html.addElement((Element)a2);
        }
        if (wstore.isMenuRegistrations()) {
            this.nl(html, false);
            a2 = new a("registrations.jsp");
            a2.setClass("menuSub");
            a2.addElement(Msg.translate(ctx, "A_Registration_ID"));
            html.addElement((Element)a2);
        }
    }

    private void menuSalesRep(HtmlCode html, MStore wstore) {
        Ctx ctx = JSPEnv.getCtx((HttpServletRequest)this.pageContext.getRequest());
        this.nl(html, true);
        a a2 = new a("requests_sr.jsp");
        a2.setClass("menuSub");
        a2.addElement(Msg.translate(ctx, "OpenRequests"));
        html.addElement((Element)a2);
        this.nl(html, false);
        a2 = new a("advertisements.jsp");
        a2.setClass("menuSub");
        a2.addElement(Msg.translate(ctx, "W_Advertisement_ID"));
        html.addElement((Element)a2);
        this.nl(html, false);
        a2 = new a("commissionRuns.jsp");
        a2.setClass("menuSub");
        a2.addElement(Msg.translate(ctx, "C_Commission_ID"));
        html.addElement((Element)a2);
        a2 = new a("commissionedInvoices.jsp");
        a2.setClass("menuDetail");
        a2.addElement(Msg.translate(ctx, "C_Commission_ID") + Msg.translate(ctx, "C_Invoice_ID"));
        html.addElement((Element)a2);
        this.nl(html, false);
    }

    private void menuUser(HtmlCode html, boolean isEmployee, MStore wstore) {
        a a2;
        Ctx ctx = JSPEnv.getCtx((HttpServletRequest)this.pageContext.getRequest());
        this.nl(html, true);
        if (isEmployee) {
            a2 = new a("notes.jsp");
            a2.setClass("menuMain");
            a2.addElement(Msg.translate(ctx, "AD_Note_ID"));
            html.addElement((Element)a2);
            this.nl(html, false);
        }
        a2 = new a("expenses.jsp");
        a2.setClass("menuSub");
        a2.addElement(Msg.translate(ctx, "S_TimeExpense_ID"));
        html.addElement((Element)a2);
    }

    private void nl(HtmlCode html, boolean hr2) {
        if (this.m_oneLine) {
            html.addElement("&nbsp;- ");
        } else if (hr2) {
            html.addElement((Element)new hr("90%", "left"));
        } else {
            html.addElement((Element)new br());
        }
    }

    public int doEndTag() throws JspException {
        return 6;
    }
}

