/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

class BitBuffer {
    private byte[] buffer = new byte[this.inclements];
    private int length = 0;
    private int inclements = 32;

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLengthInBits() {
        return this.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getLengthInBits(); ++i2) {
            buffer.append(this.get(i2) ? (char)'1' : '0');
        }
        return buffer.toString();
    }

    private boolean get(int index) {
        return (this.buffer[index / 8] >>> 7 - index % 8 & 1) == 1;
    }

    public void put(int num, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            this.put((num >>> length - i2 - 1 & 1) == 1);
        }
    }

    public void put(boolean bit) {
        if (this.length == this.buffer.length * 8) {
            byte[] newBuffer = new byte[this.buffer.length + this.inclements];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        if (bit) {
            int n = this.length / 8;
            this.buffer[n] = (byte)(this.buffer[n] | 128 >>> this.length % 8);
        }
        ++this.length;
    }
}

