/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.QRMath;

class Polynomial {
    private final int[] num;

    public Polynomial(int[] num) {
        this(num, 0);
    }

    public Polynomial(int[] num, int shift) {
        int offset;
        for (offset = 0; offset < num.length && num[offset] == 0; ++offset) {
        }
        this.num = new int[num.length - offset + shift];
        System.arraycopy(num, offset, this.num, 0, num.length - offset);
    }

    public int get(int index) {
        return this.num[index];
    }

    public int getLength() {
        return this.num.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(this.get(i2));
        }
        return buffer.toString();
    }

    public String toLogString() {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(QRMath.glog(this.get(i2)));
        }
        return buffer.toString();
    }

    public Polynomial multiply(Polynomial e2) {
        int[] num = new int[this.getLength() + e2.getLength() - 1];
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            for (int j = 0; j < e2.getLength(); ++j) {
                int n = i2 + j;
                num[n] = num[n] ^ QRMath.gexp(QRMath.glog(this.get(i2)) + QRMath.glog(e2.get(j)));
            }
        }
        return new Polynomial(num);
    }

    public Polynomial mod(Polynomial e2) {
        int i2;
        if (this.getLength() - e2.getLength() < 0) {
            return this;
        }
        int ratio = QRMath.glog(this.get(0)) - QRMath.glog(e2.get(0));
        int[] num = new int[this.getLength()];
        for (i2 = 0; i2 < this.getLength(); ++i2) {
            num[i2] = this.get(i2);
        }
        for (i2 = 0; i2 < e2.getLength(); ++i2) {
            int n = i2;
            num[n] = num[n] ^ QRMath.gexp(QRMath.glog(e2.get(i2)) + ratio);
        }
        return new Polynomial(num).mod(e2);
    }

    public static void main(String[] args) {
    }
}

