/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;
import com.d_project.qrcode.QRData;
import com.d_project.qrcode.QRUtil;
import java.io.UnsupportedEncodingException;

class QRKanji
extends QRData {
    public QRKanji(String data) {
        super(8, data);
    }

    public void write(BitBuffer buffer) {
        try {
            byte[] data = this.getData().getBytes(QRUtil.getJISEncoding());
            int i2 = 0;
            while (i2 + 1 < data.length) {
                int c2 = (0xFF & data[i2]) << 8 | 0xFF & data[i2 + 1];
                if (33088 <= c2 && c2 <= 40956) {
                    c2 -= 33088;
                } else if (57408 <= c2 && c2 <= 60351) {
                    c2 -= 49472;
                } else {
                    throw new IllegalArgumentException("illegal char at " + (i2 + 1) + "/" + Integer.toHexString(c2));
                }
                c2 = (c2 >>> 8 & 0xFF) * 192 + (c2 & 0xFF);
                buffer.put(c2, 13);
                i2 += 2;
            }
            if (i2 < data.length) {
                throw new IllegalArgumentException("illegal char at " + (i2 + 1));
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error(e2.getMessage());
        }
    }

    public int getLength() {
        try {
            return this.getData().getBytes(QRUtil.getJISEncoding()).length / 2;
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error(e2.getMessage());
        }
    }
}

