/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.security.GroovyCodeSourcePermission;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;

public class GroovyCodeSource {
    private CodeSource codeSource;
    private String name;
    private InputStream inputStream;
    Certificate[] certs;
    private boolean cachable;
    private File file;

    public GroovyCodeSource(String script2, String name, String codeBase) {
        this(new ByteArrayInputStream(script2.getBytes()), name, codeBase);
    }

    public GroovyCodeSource(InputStream inputStream, String name, String codeBase) {
        this.inputStream = inputStream;
        this.name = name;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new GroovyCodeSourcePermission(codeBase));
        }
        try {
            this.codeSource = new CodeSource(new URL("file", "", codeBase), (Certificate[])null);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException("A CodeSource file URL cannot be constructed from the supplied codeBase: " + codeBase);
        }
    }

    public GroovyCodeSource(File infile) throws IOException {
        final File file = new File(infile.getCanonicalPath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString() + " (" + file.getAbsolutePath() + ")");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.toString() + " (" + file.getAbsolutePath() + ") is a directory not a Groovy source file.");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file.toString() + " can not be read. Check the read permisson of the file \"" + file.toString() + "\" (" + file.getAbsolutePath() + ").");
        }
        this.file = file;
        this.inputStream = null;
        this.cachable = true;
        try {
            Object[] info = (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    Object[] info = new Object[2];
                    URL url = file.toURI().toURL();
                    info[0] = url.toExternalForm();
                    info[1] = new CodeSource(url, (Certificate[])null);
                    return info;
                }
            });
            this.name = (String)info[0];
            this.codeSource = (CodeSource)info[1];
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Could not construct a URL from: " + file);
        }
    }

    public GroovyCodeSource(URL url) throws IOException {
        if (url == null) {
            throw new RuntimeException("Could not construct a GroovyCodeSource from a null URL");
        }
        this.inputStream = url.openStream();
        this.name = url.toExternalForm();
        this.codeSource = new CodeSource(url, (Certificate[])null);
    }

    CodeSource getCodeSource() {
        return this.codeSource;
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        try {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public void setCachable(boolean b2) {
        this.cachable = b2;
    }

    public boolean isCachable() {
        return this.cachable;
    }
}

