/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm.tree;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.Attribute;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Type;
import groovyjarjarasm.asm.tree.AbstractInsnNode;
import groovyjarjarasm.asm.tree.AnnotationNode;
import groovyjarjarasm.asm.tree.FieldInsnNode;
import groovyjarjarasm.asm.tree.IincInsnNode;
import groovyjarjarasm.asm.tree.InsnNode;
import groovyjarjarasm.asm.tree.IntInsnNode;
import groovyjarjarasm.asm.tree.JumpInsnNode;
import groovyjarjarasm.asm.tree.LabelNode;
import groovyjarjarasm.asm.tree.LdcInsnNode;
import groovyjarjarasm.asm.tree.LineNumberNode;
import groovyjarjarasm.asm.tree.LocalVariableNode;
import groovyjarjarasm.asm.tree.LookupSwitchInsnNode;
import groovyjarjarasm.asm.tree.MemberNode;
import groovyjarjarasm.asm.tree.MethodInsnNode;
import groovyjarjarasm.asm.tree.MethodNode$1;
import groovyjarjarasm.asm.tree.MultiANewArrayInsnNode;
import groovyjarjarasm.asm.tree.TableSwitchInsnNode;
import groovyjarjarasm.asm.tree.TryCatchBlockNode;
import groovyjarjarasm.asm.tree.TypeInsnNode;
import groovyjarjarasm.asm.tree.VarInsnNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodNode
extends MemberNode
implements MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public final List exceptions;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public final List instructions;
    public final List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;
    public List lineNumbers;

    public MethodNode(int n, String string, String string2, String string3, String[] stringArray) {
        this.access = n;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = new ArrayList(stringArray == null ? 0 : stringArray.length);
        boolean bl = (n & 0x400) != 0;
        this.instructions = new ArrayList(bl ? 0 : 24);
        if (!bl) {
            this.localVariables = new ArrayList(5);
            this.lineNumbers = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new MethodNode$1(this, 0));
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitCode() {
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string) {
        this.instructions.add(new TypeInsnNode(n, string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n, string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.instructions.add(new MethodInsnNode(n, string, string2, string3));
    }

    public void visitJumpInsn(int n, Label label2) {
        this.instructions.add(new JumpInsnNode(n, label2));
    }

    public void visitLabel(Label label2) {
        this.instructions.add(new LabelNode(label2));
    }

    public void visitLdcInsn(Object object2) {
        this.instructions.add(new LdcInsnNode(object2));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label2, Label[] labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, label2, labelArray));
    }

    public void visitLookupSwitchInsn(Label label2, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(label2, nArray, labelArray));
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n));
    }

    public void visitTryCatchBlock(Label label2, Label label3, Label label4, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(label2, label3, label4, string));
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label2, Label label3, int n) {
        if (this.localVariables == null) {
            this.localVariables = new ArrayList(1);
        }
        this.localVariables.add(new LocalVariableNode(string, string2, string3, label2, label3, n));
    }

    public void visitLineNumber(int n, Label label2) {
        if (this.lineNumbers == null) {
            this.lineNumbers = new ArrayList(1);
        }
        this.lineNumbers.add(new LineNumberNode(n, label2));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n;
        int n2;
        Object object2;
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor == null) {
            return;
        }
        if (this.annotationDefault != null) {
            object2 = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)object2, null, this.annotationDefault);
            object2.visitEnd();
        }
        int n3 = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (AnnotationNode)this.visibleAnnotations.get(n2);
            ((AnnotationNode)object2).accept(methodVisitor.visitAnnotation(((AnnotationNode)object2).desc, true));
        }
        n3 = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (AnnotationNode)this.invisibleAnnotations.get(n2);
            ((AnnotationNode)object2).accept(methodVisitor.visitAnnotation(((AnnotationNode)object2).desc, false));
        }
        n3 = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = this.visibleParameterAnnotations[n2];
            if (object2 == null) continue;
            for (n = 0; n < object2.size(); ++n) {
                annotationNode = (AnnotationNode)object2.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, true));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = this.invisibleParameterAnnotations[n2];
            if (object2 == null) continue;
            for (n = 0; n < object2.size(); ++n) {
                annotationNode = (AnnotationNode)object2.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, false));
            }
        }
        n3 = this.attrs == null ? 0 : this.attrs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            methodVisitor.visitAttribute((Attribute)this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            for (n2 = 0; n2 < this.instructions.size(); ++n2) {
                ((AbstractInsnNode)this.instructions.get(n2)).accept(methodVisitor);
            }
            for (n2 = 0; n2 < this.tryCatchBlocks.size(); ++n2) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(n2)).accept(methodVisitor);
            }
            n3 = this.localVariables == null ? 0 : this.localVariables.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((LocalVariableNode)this.localVariables.get(n2)).accept(methodVisitor);
            }
            n3 = this.lineNumbers == null ? 0 : this.lineNumbers.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((LineNumberNode)this.lineNumbers.get(n2)).accept(methodVisitor);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
        }
        methodVisitor.visitEnd();
    }
}

