/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import net.sf.jasperreports.components.list.BaseListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseDatasetRun;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;

public class ListComponentCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        ListComponent listComponent = (ListComponent)component;
        JRDatasetRun datasetRun = listComponent.getDatasetRun();
        collector.collect(datasetRun);
        JRExpressionCollector datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
        JRElement[] elements = listComponent.getContents().getElements();
        if (elements != null) {
            for (int i2 = 0; i2 < elements.length; ++i2) {
                elements[i2].collectExpressions(datasetCollector);
            }
        }
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        ListComponent listComponent = (ListComponent)component;
        JRBaseDatasetRun datasetRun = baseFactory.getDatasetRun(listComponent.getDatasetRun());
        BaseListContents listContents = new BaseListContents(listComponent.getContents(), baseFactory);
        StandardListComponent compiledComponent = new StandardListComponent();
        compiledComponent.setDatasetRun(datasetRun);
        compiledComponent.setContents(listContents);
        return compiledComponent;
    }

    public void verify(Component component, JRVerifier verifier) {
        ListComponent listComponent = (ListComponent)component;
        JRDatasetRun datasetRun = listComponent.getDatasetRun();
        if (datasetRun == null) {
            verifier.addBrokenRule("No list subdataset run set", (Object)listComponent);
        } else {
            verifier.verifyDatasetRun(datasetRun);
        }
        ListContents listContents = listComponent.getContents();
        if (listContents == null) {
            verifier.addBrokenRule("No list contents set", (Object)listComponent);
        } else {
            JRElement[] elements;
            if (listContents.getHeight() < 0) {
                verifier.addBrokenRule("List contents height must be positive.", (Object)listContents);
            }
            if ((elements = listContents.getElements()) != null) {
                for (int i2 = 0; i2 < elements.length; ++i2) {
                    JRElement element = elements[i2];
                    verifier.verifyElement(element);
                    if (element.getX() < 0 || element.getY() < 0) {
                        verifier.addBrokenRule("Element must be placed at positive coordinates.", (Object)element);
                    }
                    if (element.getY() + element.getHeight() <= listContents.getHeight()) continue;
                    verifier.addBrokenRule("Element reaches outside list contents height: y = " + element.getY() + ", height = " + element.getHeight() + ", list contents height = " + listContents.getHeight() + ".", (Object)element);
                }
            }
        }
    }
}

