/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBasePen
implements JRPen,
Serializable,
Cloneable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LINE_WIDTH = "lineWidth";
    public static final String PROPERTY_LINE_STYLE = "lineStyle";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    protected JRPenContainer penContainer = null;
    protected Float lineWidth = null;
    protected Byte lineStyle = null;
    protected Color lineColor = null;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBasePen(JRPenContainer penContainer) {
        this.penContainer = penContainer;
    }

    public JRStyleContainer getStyleContainer() {
        return this.penContainer;
    }

    public Float getLineWidth() {
        return JRStyleResolver.getLineWidth(this, this.penContainer.getDefaultLineWidth());
    }

    public Float getOwnLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.setLineWidth(new Float(lineWidth));
    }

    public void setLineWidth(Float lineWidth) {
        Float old = this.lineWidth;
        this.lineWidth = lineWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_WIDTH, old, this.lineWidth);
    }

    public Byte getLineStyle() {
        return JRStyleResolver.getLineStyle(this);
    }

    public Byte getOwnLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(byte lineStyle) {
        this.setLineStyle(new Byte(lineStyle));
    }

    public void setLineStyle(Byte lineStyle) {
        Byte old = this.lineStyle;
        this.lineStyle = lineStyle;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_STYLE, old, this.lineStyle);
    }

    public Color getLineColor() {
        return JRStyleResolver.getLineColor(this, this.penContainer.getDefaultLineColor());
    }

    public Color getOwnLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        Color old = this.lineColor;
        this.lineColor = lineColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_COLOR, old, this.lineColor);
    }

    public String getStyleNameReference() {
        return null;
    }

    public JRPen clone(JRPenContainer penContainer) {
        JRBasePen clone = null;
        try {
            clone = (JRBasePen)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        clone.penContainer = penContainer;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePen jRBasePen = this;
        synchronized (jRBasePen) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

