/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ConvertChartContext;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import org.jfree.chart.JFreeChart;

public class ChartConverter
extends ElementConverter {
    private static final ChartConverter INSTANCE = new ChartConverter();

    private ChartConverter() {
    }

    public static ChartConverter getInstance() {
        return INSTANCE;
    }

    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRChart chart = (JRChart)element;
        this.copyElement(reportConverter, chart, printImage);
        printImage.copyBox(chart.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(chart.getAnchorNameExpression()));
        printImage.setBookmarkLevel(chart.getBookmarkLevel());
        printImage.setLinkType(chart.getLinkType());
        printImage.setOnErrorType((byte)3);
        printImage.setRenderer(this.getRenderer(reportConverter, chart));
        printImage.setScaleImage((byte)1);
        return printImage;
    }

    private JRRenderable getRenderer(ReportConverter reportConverter, JRChart chart) {
        String themeName;
        String renderType = chart.getRenderType();
        if (renderType == null) {
            renderType = JRProperties.getProperty(reportConverter.getReport(), "net.sf.jasperreports.chart.render.type");
        }
        if ((themeName = chart.getTheme()) == null) {
            themeName = JRProperties.getProperty(reportConverter.getReport(), "net.sf.jasperreports.chart.theme");
        }
        ChartTheme theme = ChartUtil.getChartTheme(themeName);
        ConvertChartContext chartContext = new ConvertChartContext(chart);
        JFreeChart jfreeChart = null;
        try {
            jfreeChart = theme.createChart(chartContext);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, chart.getWidth(), chart.getHeight());
        return ChartUtil.getChartRendererFactory(renderType).getRenderer(jfreeChart, null, rectangle);
    }
}

